#include <bits/stdc++.h>

typedef long long ll;
typedef unsigned long long u64;

static const int MOD = 999983;
inline int word_cnt(int n_bits) { return (n_bits + 63) >> 6; }

inline u64 extract64(const std::vector<u64> &V, int bit_pos) {
  int w = bit_pos >> 6;
  int sh = bit_pos & 63;
  if (w >= (int)V.size())
    return 0ULL;
  u64 lo = V[w] >> sh;
  if (sh == 0)
    return lo;
  u64 hi = 0ULL;
  if (w + 1 < (int)V.size())
    hi = V[w + 1] << (64 - sh);
  return lo | hi;
}

int main() {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);

  int n;
  ll s_ll;
  if (!(std::cin >> n >> s_ll))
    return 0;

  const int W = word_cnt(MOD);
  std::vector<u64> B(W, 0ULL);
  std::vector<u64> R(W, 0ULL);
  auto set_bit = [&](int x) {
    int w = x >> 6, b = x & 63;
    B[w] |= (1ULL << b);
    int rx = (MOD - 1) - x;
    int rw = rx >> 6, rb = rx & 63;
    R[rw] |= (1ULL << rb);
  };
  auto has_bit = [&](int x) -> bool { return (B[x >> 6] >> (x & 63)) & 1ULL; };

  int answer = 0; // |V|

  for (int i = 0; i < n; ++i) {
    s_ll = (s_ll * 618023LL + 1) % MOD;
    int s = (int)s_ll;

    int upto = s >> 1;
    int full_words = (upto + 1) >> 6;
    int tail_bits = (upto + 1) & 63;
    const int K = (MOD - 1) - s;

    unsigned parity = 0;

    for (int w = 0; w < full_words; ++w) {
      u64 L = B[w];
      int bit_pos = K + (w << 6);
      u64 Rwin = extract64(R, bit_pos);
      parity ^= (__builtin_popcountll(L & Rwin) & 1u);
    }

    if (tail_bits) {
      int w = full_words;
      u64 L = B[w];
      u64 mask = (tail_bits == 64 ? ~0ULL : ((1ULL << tail_bits) - 1ULL));
      L &= mask;

      int bit_pos = K + (w << 6);
      u64 Rwin = extract64(R, bit_pos) & mask;

      parity ^= (__builtin_popcountll(L & Rwin) & 1u);
    }

    if (parity == 0u && !has_bit(s)) {
      set_bit(s);
      ++answer;
    }
  }

  std::cout << answer << '\n';
  return 0;
}
