#include <bits/stdc++.h>

typedef long long ll;

struct Point {
  ll x, y;
  bool operator<(const Point &o) const {
    return x < o.x || (x == o.x && y < o.y);
  }
};

ll cross(const Point &a, const Point &b, const Point &c) {
  return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

ll dist2(const Point &a, const Point &b) {
  ll dx = a.x - b.x, dy = a.y - b.y;
  return dx * dx + dy * dy;
}

std::vector<Point> convex_hull(std::vector<Point> p) {
  sort(p.begin(), p.end());
  p.erase(unique(p.begin(), p.end(),
                 [](auto &a, auto &b) { return a.x == b.x && a.y == b.y; }),
          p.end());
  if (p.size() <= 2)
    return p;
  std::vector<Point> lo, up;
  for (auto &pt : p) {
    while (lo.size() >= 2 && cross(lo[lo.size() - 2], lo.back(), pt) <= 0)
      lo.pop_back();
    lo.push_back(pt);
  }
  for (int i = (int)p.size() - 1; i >= 0; --i) {
    while (up.size() >= 2 && cross(up[up.size() - 2], up.back(), p[i]) <= 0)
      up.pop_back();
    up.push_back(p[i]);
  }
  lo.pop_back();
  up.pop_back();
  lo.insert(lo.end(), up.begin(), up.end());
  return lo;
}

ll gcdll(ll a, ll b) {
  if (a < 0)
    a = -a;
  if (b < 0)
    b = -b;
  while (b) {
    ll t = a % b;
    a = b;
    b = t;
  }
  return a;
}

void output_lines(Point A, Point B) {
  ll a = B.x - A.x;
  ll b = B.y - A.y;
  ll c1 = -(a * A.x + b * A.y);
  ll c2 = -(a * B.x + b * B.y);

  ll g = gcdll(a, b);
  if (g) {
    a /= g;
    b /= g;
    c1 /= g;
    c2 /= g;
  }
  if (a < 0 || (a == 0 && b < 0)) {
    a = -a;
    b = -b;
    c1 = -c1;
    c2 = -c2;
  }
  if (c1 < c2)
    std::swap(c1, c2);

  std::cout << a << " " << b << " " << c1 << "\n";
  std::cout << a << " " << b << " " << c2 << "\n";
}

int main() {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);

  int n;
  std::cin >> n;
  std::vector<Point> pts(n);
  for (int i = 0; i < n; i++)
    std::cin >> pts[i].x >> pts[i].y;

  auto hull = convex_hull(pts);
  int h = (int)hull.size();

  if (h <= 1) {
    std::cout << "0 1 0\n0 1 0\n";
    return 0;
  }
  if (h == 2) {
    output_lines(hull[0], hull[1]);
    return 0;
  }

  ll best = 0;
  int bi = 0, bj = 1, j = 1;
  for (int i = 0; i < h; i++) {
    int ni = (i + 1) % h;
    while (true) {
      int nj = (j + 1) % h;
      ll cur = llabs(cross(hull[i], hull[ni], hull[j]));
      ll nxt = llabs(cross(hull[i], hull[ni], hull[nj]));
      if (nxt > cur)
        j = nj;
      else
        break;
    }
    ll d2 = dist2(hull[i], hull[j]);
    if (d2 > best) {
      best = d2;
      bi = i;
      bj = j;
    }
  }

  output_lines(hull[bi], hull[bj]);
  return 0;
}
