
#include <bits/stdc++.h>
using namespace std;

using u64 = unsigned long long;
using ll = long long;

static const int MOD = 999983;
static const int W = (MOD + 63) >> 6;

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);

  int n;
  ll s_ll;
  if (!(cin >> n >> s_ll))
    return 0;

  static u64 B[W];
  static u64 RS[64][W + 1];

  auto has_bit = [&](int x) -> bool { return (B[x >> 6] >> (x & 63)) & 1ULL; };

  auto add_value = [&](int x) {
    int w = x >> 6, b = x & 63;
    B[w] |= (1ULL << b);

    int pos = (MOD - 1) - x;
    int kw = pos >> 6;
    int kb = pos & 63;

    for (int r = 0; r < 64; ++r) {
      if (kb >= r) {
        RS[r][kw] |= (1ULL << (kb - r));
      } else if (kw > 0) {
        RS[r][kw - 1] |= (1ULL << (kb + 64 - r));
      }
    }
  };

  int answer = 0;

  for (int i = 0; i < n; ++i) {
    s_ll = (s_ll * 618023LL + 1) % MOD;
    int s = (int)s_ll;

    int upto = s >> 1;
    int full_words = (upto + 1) >> 6;
    int tail_bits = (upto + 1) & 63;

    int K = (MOD - 1) - s;
    int q = K >> 6;
    int r = K & 63;

    const u64 *__restrict bptr = B;
    const u64 *__restrict rptr = RS[r] + q;

    u64 acc = 0;
    for (int w = 0; w < full_words; ++w) {
      acc ^= (bptr[w] & rptr[w]);
    }
    if (tail_bits) {
      u64 mask = (tail_bits == 64 ? ~0ULL : ((1ULL << tail_bits) - 1ULL));
      acc ^= ((bptr[full_words] & rptr[full_words]) & mask);
    }

    unsigned parity = __builtin_parityll(acc);

    if (parity == 0u && !has_bit(s)) {
      add_value(s);
      ++answer;
    }
  }

  cout << answer << '\n';
  return 0;
}
