import sys
data = sys.stdin.read().strip().split()
it = iter(data)
n = int(next(it))
coords = []
vals = []
for i in range(2 * n - 1):
    r = i - (n - 1)
    qmin = max(-(n - 1), r - (n - 1))
    qmax = min((n - 1), -r + (n - 1))
    for q in range(qmin, qmax + 1):
        x = q
        z = r
        y = -x - z
        coords.append((x, y, z))
        vals.append(int(next(it)))
ops = next(it)
M = [[1,0,0],[0,1,0],[0,0,1]]

def matmul(A, B):
    return [[A[i][0] * B[0][j] + A[i][1] * B[1][j] + A[i][2] * B[2][j] for j in range(3)] for i in range(3)]

MR = [[0,0,-1],[-1,0,0],[0,-1,0]]
ML = [[0,-1,0],[0,0,-1],[-1,0,0]]
MT = [[0,1,0],[1,0,0],[0,0,1]]
for c in ops:
    if c == 'R':
        M = matmul(MR, M)
    elif c == 'L':
        M = matmul(ML, M)
    elif c == 'T':
        M = matmul(MT, M)
posmap = {}
for (x, y, z), v in zip(coords, vals):
    x2 = M[0][0]*x + M[0][1]*y + M[0][2]*z
    y2 = M[1][0]*x + M[1][1]*y + M[1][2]*z
    z2 = M[2][0]*x + M[2][1]*y + M[2][2]*z
    posmap[(x2,y2,z2)] = v
out_lines = []
for i in range(2 * n - 1):
    r = i - (n - 1)
    qmin = max(-(n - 1), r - (n - 1))
    qmax = min((n - 1), -r + (n - 1))
    row = []
    for q in range(qmin, qmax + 1):
        x = q
        z = r
        y = -x - z
        row.append(str(posmap[(x, y, z)]))
    out_lines.append(" ".join(row))
sys.stdout.write("\n".join(out_lines))