from sys import stdout
 
from functools import lru_cache
 
@lru_cache(maxsize=None)
def collatz_cost(n, max_depth=128, current_depth=0):
    if current_depth >= max_depth:
        return 0
    if n == 1:
        return 1
    elif n % 2 == 0:
        next_n = n // 2
    else:
        next_n = 3 * n + 1
    return len(str(next_n)) + collatz_cost(next_n, max_depth, current_depth + 1)
 
t = int(input())
 
 
for i in range(t):
    n = int(input())
 
    is_done = False
 
    cost = collatz_cost(n)
 
    if cost < 800:
        while True:
            print("collatz")
            stdout.flush()
            n = int(input())
            if n == 1:
                break
        continue
    else:
        while n != 1:
            if is_done:
                break
 
            while n > 1 and n % 2 == 0:
                print("collatz")
                stdout.flush()
                n = int(input())
                if n == 1:
                    is_done = True
                    break
             
            if is_done or n == 1:
                break
 
            cost = collatz_cost(n)
            if cost < 1200:
                print("collatz")
 
            else:
                print("random")

            stdout.flush()
            n = int(input())
