//#define ONPC
#pragma comment(linker, "/stack:256000000")
#pragma gcc optimize("O3")
#pragma gcc target("sse4")
#define _CRT_SECURE_NO_WARNINGS
#define _USE_MATH_DEFINES
#define mp make_pair
#define gl getline
#define pb push_back
#define eb emplace_back
#define ob pop_back
#define sz(x) ((int)(x.size()))
#define UM unordered_map
#define US unordered_set
#define X first
#define Y second
#define whole(x) x.begin(), x.end()
#include <iostream>
#include <vector>
#include <iomanip>
#include <algorithm>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <string>
#include <queue>
#include <cmath>
#include <climits>
#include <bitset>
#include <random>
#include <ctime>
#include <chrono>
#include <cstdio>
#include <cstring>
using namespace std;
typedef long long ll;
typedef long double ld;
typedef pair<ll, ll> pll;
typedef pair<int, int> pii;
typedef vector<pii> vpii;
typedef vector<vpii> vvpii;
typedef pair<double, double> pdd;
typedef vector<int> vi;
typedef vector<vi> vvi;
typedef vector<vvi> vvvi;
typedef vector<bool> vb;
typedef vector<vb> vvb;
typedef vector<pll> vpll;
typedef vector<ll> vl;
typedef vector<vl> vvl;
typedef pair<bool, ll> pbl;
typedef vector<pbl> vpbl;
typedef vector<double> vd;
typedef vector<vd> vvd;
typedef vector<pdd> vpdd;
typedef vector<string> vs;
mt19937 rng(2391);
mt19937 gnr(chrono::high_resolution_clock::now().time_since_epoch().count());

inline int modulo(int a, int b) {
    const int result = a % b;
    return result >= 0 ? result : result + b;
}

int char_pos(char c) {
    return static_cast<int>(c - 'A');
}

string chars = "ABCDEFG";

int calc_position_shift(char prev, char current) {
    for (int i = 0; i <= 3; ++i) {
        if (chars[(char_pos(prev) + i) % 7] == current) {
            return i;
        }
    }


    for (int i = 0; i <= 3; ++i) {
        if (chars[modulo(char_pos(prev) - i, 7)] == current) {
            return -i;
        }
    }
}

bool solve_for_octave(const string&s, int octave) {
    int position = octave * 7 + char_pos(s[0]);

    int left_bound = 0;
    int right_bound = 2 + 7 * 7;

    char prev = s[0];
    for (int i = 1; i < s.length(); ++i) {
        char current = s[i];
        int  position_shift = calc_position_shift(prev, current);


        if (position + position_shift < left_bound) {
            return false;
        }
        if (position + position_shift > right_bound) {
            return false;
        }
        position = position + position_shift;
        prev = current;
    }

    return true;
}

bool solve(const string &s) {
    if (s[0] == 'A' || s[0] == 'B' || s[0] == 'C') {
        for (int octave = 0; octave < 8; ++octave) {
            if (solve_for_octave(s, octave)) {
                return true;
            }
        }
    } else {
        for (int octave = 0; octave < 7; ++octave) {
            if (solve_for_octave(s, octave)) {
                return true;
            }
        }
    }
    return false;
}


int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    cerr.tie(0);
#ifdef ONPC
    freopen("input.txt", "rt", stdin);
    // freopen("output.txt", "wt", stdout);
    auto start_time = clock();
    cerr << setprecision(3) << fixed;
#endif


    int t;
    cin >> t;

    for (int test = 0; test < t; ++test) {
        string s;
        cin >> s;

        bool result = solve(s);
        if (result) {
            cout << "YES" << "\n";
        } else {
            cout << "NO" << "\n";
        }
    }

#ifdef ONPC
    auto end_time = clock();
    cerr << "Execution time: " << (end_time - start_time) * (int) 1e3 / CLOCKS_PER_SEC << " ms\n";
#endif
    return 0;
}