//#include <cassert>
//
//const int MAX_MEM = 5e8;
//int mpos = 0;
//char mem[MAX_MEM];
//using namespace std;
//
//void *operator new(size_t n)
//{
//    assert((mpos += n) <= MAX_MEM);
//    return (void *) (mem + mpos - n);
//}
//
//void operator delete(void *) noexcept
//{}
//
//void operator delete(void *, size_t) noexcept
//{}

//#pragma  GCC target("popcnt")

#include <bits/stdc++.h>
#include "ext/pb_ds/assoc_container.hpp"
#include "ext/pb_ds/tree_policy.hpp"

#define int long long
using namespace std;
using namespace __gnu_pbds;
typedef long double ld;
typedef unsigned long long ull;
typedef long long ll;
template<typename T>
using ordered_multiset = tree<T, null_type, less<T>, rb_tree_tag, tree_order_statistics_node_update>;

template<typename T1, typename T2>
ostream &operator<<(ostream &_out, const pair<T1, T2> &_a)
{
    _out << _a.first << ' ' << _a.second << '\n';
    return _out;
}

template<typename T1, typename T2>
istream &operator>>(istream &_in, pair<T1, T2> &_a)
{
    _in >> _a.first >> _a.second;
    return _in;
}

template<typename T>
ostream &operator<<(ostream &_out, const vector<T> &_a)
{
    for (const auto &i: _a)_out << i << ' ';
    return _out;
}

template<typename T>
ostream &operator<<(ostream &_out, const vector<vector<T>> &_a)
{
    for (const auto &i: _a)_out << i << '\n';
    return _out;
}

template<typename T>
istream &operator>>(istream &_in, vector<T> &_a)
{
    for (auto &i: _a)_in >> i;
    return _in;
}

void print(bool x)
{
    if (x)cout << "White\n";
    else cout << "Black\n";
}

template<typename T, typename integer>
void in(vector<T> &a, integer &n)
{
    cin >> n;
    a.resize(n);
    cin >> a;
}

template<typename T, typename integer>
void in_vc(vector<T> &a, const integer &n)
{
    a.resize(n);
    cin >> a;
}

struct A
{
    int a;
    int b;
    int c;

    A(int a = {}, int b = {}, int c = {}) : a(a), b(b), c(c)
    {}

    void rot()
    {
        swap(a, b);
        swap(c, b);
        a *= -1;
        b *= -1;
        c *= -1;
    }

    void inv()
    {
        swap(a, b);
        a *= -1;
        b *= -1;
        c *= -1;
    }

    A operator+(const A &other) const
    {
        return {a + other.a, b + other.b, c + other.c};
    }

    A operator*(int x) const
    {
        return {a * x, b * x, c * x};
    }

    A operator-() const
    {
        return {-a, -b, -c};
    }

    bool operator<(const A &other) const
    {
        if (a != other.a)return a < other.a;
        if (b != other.b)return b < other.b;
        return c < other.c;
    }
};

const A a = {2, -1, -1};
const A b = {-1, 2, -1};
const A c = {-1, -1, 2};

template<typename T>
static T pow(const T &a, ll n)
{
    if (n == 0)return 1;
    if (n % 2 == 1)return pow(a, n - 1) * a;
    T temp = pow(a, n / 2);
    return temp * temp;
}

struct Zm
{
private:
    ll k{0};
    static const ll MOD = 1e9+7;
public:
    Zm() = default;

    Zm(ll k)
    {
        this->k = k % MOD;
        this->k += MOD * (this->k < 0);
    }

    Zm &operator+=(const Zm &other)
    {
        k += other.k;
        k -= MOD * (k >= MOD);
        return *this;
    }

    Zm &operator-=(const Zm &other)
    {
        k -= other.k;
        k += MOD * (k < 0);
        return *this;
    }

    Zm &operator*=(const Zm &other)
    {
        k *= other.k;
        k %= MOD;
        return *this;
    }

    Zm &operator/=(const Zm &other)
    {
        return (*this) *= other.inv();
    }

    [[nodiscard]] Zm inv() const
    {
        return pow(*this, MOD - 2);
    }

    Zm operator/(const Zm &other) const
    {
        Zm t = *this;
        return t /= other;
    }

    Zm operator+(const Zm &other) const
    {
        Zm t = *this;
        return t += other;
    }

    Zm operator-(const Zm &other) const
    {
        Zm t = *this;
        return t -= other;
    }

    Zm operator*(const Zm &other) const
    {
        Zm t = *this;
        return t *= other;
    }

    operator ll() const
    {
        return k;
    }
};

struct Test
{


    Test()
    {
        ll n = 1e6+100;
        vector<Zm> f(n);
        vector<Zm> ch(n), zn(n);
        ch[1]=2;
        zn[1]=3;
        for(int i = 2; i<n; i++){
            ch[i]=ch[i-1]*Zm(2*i);
            zn[i]=zn[i-1]*Zm(2*i+1);
        }

        f[1]=6;
        for(int i = 2; i<n; i++){
            f[i]=(f[i-1]+ch[i-1])*Zm(2*i+1);

        }
        //cout<<f<<"\n"<<ch<<"\n"<<zn<<"\n";
        ll q;
        cin>>q;
        while(q--){
            ll p, m;
            cin>>p>>m;
            cout<<(f[p]+ch[p]*Zm(m))/zn[p]<<"\n";
        }
    }
};


signed main()
{
#ifdef home
    freopen(".in", "r", stdin);
    freopen(".out", "w", stdout);

    auto start = clock();
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
#endif
    int t = 1;
    //cin >> t;
    cout.precision(20);
    while (t--)
    {
        Test();
    }
#ifdef home
    cerr << "Time: " << (clock() - start) * 1e3 / CLOCKS_PER_SEC << "ms\n";
#endif
}
