#include <iostream>
#include <iomanip>
#include <algorithm>
#include <functional>
#include <utility>
#include <cstring>
#include <string>
#include <vector>
#include <queue>
#include <stack>
#include <map>
#include <set>
#include <chrono>
#include <random>
#include <bitset>
#include <cmath>
#include <ranges>
#include <unordered_set>

using namespace std;

typedef long long llong;
typedef unsigned long long ull;
typedef long double ldouble;
typedef pair<int, int> pint;
typedef pair<llong, llong> plong;

#define flr(iter, first, last) for(int iter = first; iter <= last; iter++)
#define frl(iter, last, first) for(int iter = last; iter >= first; iter--)
#define fir(iter, limit) for(int iter = 0; iter < limit; iter++)

#ifdef LOCAL_JUDGE
#define clockinit time_t __clockStart = 0, __clockEnd = 0;
#define clockstart __clockStart = clock();
#define clockstop __clockEnd = clock();
#define clocktime (__clockEnd - __clockStart)
void print_clock_time(time_t clockTime)
{
    cout << "Time elapsed: " << clockTime << " ticks" << endl;
}
#else
#define clockinit
#define clockstart
#define clockstop
#define clocktime
#define print_clock_time(clockTime)
#endif /* ONLINE_JUDGE */

#pragma region quick_snippets

// ONLY FOR PREALLOCATED VECTORS
template<typename _T>
istream& operator>>(istream& istr, vector<_T>& vec)
{
    for (int i = 0; i < vec.size(); i++)
    {
        istr >> vec[i];
    }

    return istr;
}

template<typename _X, typename _Y>
ostream& operator<<(ostream& ostr, const pair<_X, _Y>& pair)
{
    ostr << pair.first << ' ' << pair.second;
    return ostr;
}

template<typename _T>
ostream& operator<<(ostream& ostr, const vector<_T>& vec)
{
    for (int i = 0; i < vec.size() - 1; i++)
    {
        ostr << vec[i] << ' ';
    }

    ostr << vec.back();

    return ostr;
}

template<typename _T>
vector<_T> read_vector(int length, int shift = 0)
{
    vector<_T> v(shift + length);

    for (int i = 0; i < shift; i++)
    {
        v[i] = _T{};
    }

    for (int i = shift; i < shift + length; i++)
    {
        cin >> v[i];
    }

    return v;
}

template <typename _T>
auto tensor(size_t size) {
    return vector<_T>(size);
}

template <typename _T, typename... _S>
auto tensor(size_t first, _S... sizes) {
    using inner_type = decltype(tensor<_T>(sizes...));
    return vector<inner_type>(first, tensor<_T>(sizes...));
}

template <typename _T>
auto maxx(_T a) {
    return a;
}

template <typename _T, typename... _S>
auto maxx(_T a, _S... z) {
    return max(a, maxx(z...));
}

template <typename _T>
auto minx(_T a) {
    return a;
}

template <typename _T, typename... _S>
auto minx(_T a, _S... z) {
    return min(a, minx(z...));
}

template<typename _T>
void print_vector(const vector<_T>& vec, char separator = ' ', string terminator = "\n")
{
    for (int i = 0; i < vec.size() - 1; i++)
    {
        cout << vec[i] << separator;
    }

    cout << vec.back();

    if (terminator == "\n")
    {
        cout << endl;
    }
    else
    {
        cout << terminator;
    }
}

string YES_ANS, NO_ANS;

void pyn(bool condition)
{
    if (condition)
    {
        cout << YES_ANS << endl;
    }
    else
    {
        cout << NO_ANS << endl;
    }
}

void flush_out()
{
    fflush(stdout);
}

#define maxel(begin, end) (*max_element(begin, end))
#define minel(begin, end) (*min_element(begin, end))
#define maxidx(begin, end) (max_element(begin, end) - begin)
#define minidx(begin, end) (min_element(begin, end) - begin)
#define maxel(iterable) (*max_element(iterable.begin(), iterable.end()))
#define minel(iterable) (*min_element(iterable.begin(), iterable.end()))
#define maxidx(iterable) (max_element(iterable.begin(), iterable.end()) - iterable.begin())
#define minidx(iterable) (min_element(iterable.begin(), iterable.end()) - iterable.begin())

template<typename _Tb, typename _Te>
_Tb binpow(const _Tb& base, const _Te exp)
{
    if (exp == 0)
    {
        return _Tb{ 1 };
    }

    if (exp % 2 == 0)
    {
        _Tb anssqrt = binpow(base, exp / 2);
        return anssqrt * anssqrt;
    }
    else
    {
        return binpow(base, exp - 1) * base;
    }
}

// Returns the leftmost value x in [l;r) where check(x) == true
// assuming that check is a sign-shaped function on [l;r)
// if nothing found, returns r
template<typename _TD, typename _Pred>
_TD binsearch(const _TD& l, const _TD& r, _Pred check)
{
    _TD lb = l, rb = r;

    while (lb < rb)
    {
        _TD mid = lb + (rb - lb) / 2;
        if (check(mid)) rb = mid;
        else lb = mid + 1;
    }

    return lb;
}

template<typename _Int>
_Int gcd(_Int a, _Int b)
{
    return b ? gcd(b, a % b) : a;
}

#pragma endregion

const ldouble math_pi_l = acosl(-1.0);
const ldouble math_pi = acos(-1.0);

#pragma region data_structures

template<typename _Integral, _Integral _Modulo>
struct mint_t
{
    _Integral value;
    mint_t() : value(0) {}
    mint_t(_Integral value) : value(value% _Modulo > 0 ? value % _Modulo : _Modulo + value % _Modulo) {}
    _Integral operator()() { return value; }
    mint_t& operator=(const mint_t& another) { value = another.value; return *this; }
    mint_t& operator=(const _Integral& non_modulo_value) { return *this = mint_t(non_modulo_value); }
    mint_t& operator+=(const mint_t& another) { value = (value + another.value) % _Modulo; return *this; }
    mint_t& operator*=(const mint_t& another) { value = (value * another.value) % _Modulo; return *this; }
    mint_t& operator-=(const mint_t& another) { _Integral nv = value - another.value; value = nv < 0 ? nv + _Modulo : nv; return *this; }
    mint_t& operator/=(const mint_t& another) { return *this; }
    mint_t operator+(const mint_t& another) { mint_t lhs = *this; lhs += another; return lhs; }
    mint_t operator*(const mint_t& another) { mint_t lhs = *this; lhs *= another; return lhs; }
    mint_t operator-(const mint_t& another) { mint_t lhs = *this; lhs -= another; return lhs; }
    mint_t operator/(const mint_t& another) { mint_t lhs = *this; lhs /= another; return lhs; }
    mint_t& operator+=(const _Integral& non_modulo_value) { return *this += mint_t(non_modulo_value); }
    mint_t& operator*=(const _Integral& non_modulo_value) { return *this *= mint_t(non_modulo_value); }
    mint_t& operator-=(const _Integral& non_modulo_value) { return *this -= mint_t(non_modulo_value); }
    mint_t& operator/=(const _Integral& non_modulo_value) { return *this /= mint_t(non_modulo_value); }
    mint_t operator+(const _Integral& non_modulo_value) { return *this + mint_t(non_modulo_value); }
    mint_t operator*(const _Integral& non_modulo_value) { return *this * mint_t(non_modulo_value); }
    mint_t operator-(const _Integral& non_modulo_value) { return *this - mint_t(non_modulo_value); }
    mint_t operator/(const _Integral& non_modulo_value) { return *this / mint_t(non_modulo_value); }
};

template<typename _Integral, _Integral _Modulo>
struct mintof_t
{
    _Integral value;
    bool _of;
    mintof_t() : value(0), _of(false) {}
    mintof_t(_Integral value) : value(value% _Modulo), _of(value >= _Modulo) {}
    _Integral operator()() { return value; }
    bool of() { return _of; }
    mintof_t& operator=(const _Integral& non_modulo_value) { value = non_modulo_value % _Modulo; return *this; }
    mintof_t& operator=(const mintof_t& another) { value = another.value; return *this; }
    mintof_t& operator+=(const _Integral& non_modulo_value) { value = (value + non_modulo_value % _Modulo) % _Modulo; return *this; }
    mintof_t& operator*=(const _Integral& non_modulo_value) { value = (value * (non_modulo_value % _Modulo)) % _Modulo; return *this; }
    mintof_t operator+(const _Integral& non_modulo_value) { mintof_t lhs = *this; lhs += non_modulo_value; return lhs; }
    mintof_t operator*(const _Integral& non_modulo_value) { mintof_t lhs = *this; lhs *= non_modulo_value; return lhs; }
    mintof_t& operator+=(const mintof_t& another) { value = (value + another.value) % _Modulo; return *this; }
    mintof_t& operator*=(const mintof_t& another) { value = (value * another.value) % _Modulo; return *this; }
    mintof_t operator+(const mintof_t& another) { mintof_t lhs = *this; lhs += another; return lhs; }
    mintof_t operator*(const mintof_t& another) { mintof_t lhs = *this; lhs *= another; return lhs; }
};

#pragma endregion

//#define INTERACTIVE_DEBUG
//#define GEN_TEST
int main()
{
#if defined(LOCAL_JUDGE) && !defined(INTERACTIVE_DEBUG)

#ifndef GEN_TEST

    freopen("input.txt", "rb", stdin);
    freopen("output.txt", "wb", stdout);

#else

    freopen("input.txt", "wb", stdout);

    int tst = 100000;

    srand(time(0));

    cout << tst << endl;

    for (int i = 0; i < tst; i++)
    {
        cout << i + 1 << endl;
    }

    cout << endl;

    return 0;

#endif /* GEN_TEST */

#endif /* LOCAL_JUDGE */

    clockinit;
    clockstart;

    std::cin.tie(0);
    std::ios_base::sync_with_stdio(0);

    //#define NO_TESTS

    int t;
#if defined(NO_TESTS) && !defined(LOCAL_JUDGE)
    t = 1;
#else
    cin >> t;
#endif

    const llong modulo = 998244353;
    typedef mint_t<llong, modulo> mint;
    typedef mintof_t<llong, modulo> mintof;
    typedef tuple<llong, llong, llong> tup;

    YES_ANS = "Yes";
    NO_ANS = "No";

    for (int test = 0; test < t; test++)
    {
        llong maxv = 0;
        llong minv = LLONG_MAX;

        llong x = 0;

        string s;
        cin >> s;

        char prev = s[0];
        char minc = s[0];

        vector<llong> m(256);
        m['A'] = 0;
        m['B'] = 1;
        m['C'] = 2;
        m['D'] = 3;
        m['E'] = 4;
        m['F'] = 5;
        m['G'] = 6;

        fir(i, s.length())
        {
            int a = m[prev], b = m[s[i]];
            int diff = b - a;
            if (diff >= -6 && diff <= -4 || diff >= 0 && diff <= 3)
            {
                if (diff < 0) diff += 7;
                x += diff;
            }
            else
            {
                if (diff > 0) diff -= 7;
                x += diff;
                if (x < minv) minc = s[i];
            }
            maxv = max(maxv, x);
            minv = min(minv, x);
            prev = s[i];
        }

        pyn(m[minc] + (maxv - minv) <= 51);
    }
    clockstop;
    print_clock_time(clocktime);

    return 0;
}