#include <bits/stdc++.h>
using namespace std;
#define all(o) o.begin(), o.end()
using ll = long long;

#if LOCAL
#define dbg(o) ({ cout << #o << " = " << (o) << "\n"; o;})
#else
#define dbg(o) (o)
#endif

template<typename T, typename Q>
ostream &operator <<(ostream &o, const pair<T, Q> &x) {
    o << x.first << " " << x.second;
    return o;
}

template<typename T>
ostream &operator <<(ostream &o, const vector<T> &x) {
    for (const auto &v : x) {
        o << v << " ";
    }
    return o;
}


template<typename T>
istream &operator >>(istream &o, vector<T> &x) {
    for (auto &v : x) {
        o >> v;
    }
    return o;
}

template<typename T, typename Q>
ostream &operator <<(ostream &o, const map<T, Q> &x) {
    for (const auto &v : x) {
        o << v << " ";
    }
    return o;
}

static vector<vector<pair<int, int>>> dst;

int ilog2(int x) {
    return bit_width((unsigned)x) - 1;
}

template<typename I, typename J, typename C>
void f(I a, J result, int n, vector<int> &dp, C cmp) {
    int r = 0;
    int mn = n > 0 ? *a : 0;
    for (int i = 0; i < n; ++i) {
        int x = *(a + i);
        mn = max(mn, x, cmp);
        auto it = lower_bound(dp.begin(), dp.begin() + r, x, cmp);
        if (it == dp.begin() + r) {
            r++;
            dp[r - 1] = x;
        } else {
            *it = x;
        }
        *(result + i) = {r, mn};
    }
}

struct DSU {
    vector<pair<int, vector<pair<int, int>>>> data;
    vector<int> buf;

    void add(int x, int y) {
        int i = data.size();
        data.emplace_back(-1, vector{pair{x, y}});
    }

    int find(int x) {
        if (data[x].first >= 0) {
            return data[x].first = find(data[x].first);
        }

        return x;
    }

    void merge(int x, int y) {
        x = find(x);
        y = find(y);
        if (x == y) {
            return;
        }
        if (size(x) > size(y)) {
            swap(x, y);
        }
        data[x].first += data[y].first;
        data[y].first = x;
        for (auto xy : std::move(data[y].second)) {
            data[x].second.push_back(xy);
        }
    }

    int size(int x) {
        return -data[x].first;
    }
};

mt19937_64 rng(chrono::steady_clock::now().time_since_epoch().count());

bool ask(int x, int y) {
    cout << '?' << " " << x << " " << y << endl;
    char c;
    cin >> c;
    return c == 'W';
    return rng() % 2;
}

int n;
int k;

void solve() {
    vector<bool> colors;
    map<pair<int, int>, int> cells;
    vector<pair<int, int>> checked;

    deque<pair<int, int>> q;
    DSU dsu;
    int j = 0;
    while (true) {
        k += 1;
        int x, y;
        lbl:
        if (cells.empty()) {
            x = 0, y = 0;
        } else if (q.empty()) {
            while (true) {
                auto i = uniform_int_distribution<int>(0, checked.size() - 1)(rng);
                auto [nx, ny] = checked[i];
                x = nx, y = ny;
                x += rng() % 3 - 1;
                y += rng() % 3 - 1;
                if (cells.find({x, y}) == cells.end()) break;
            }
        } else {
            while (true) {
                auto [nx, ny] = q.front();
                q.pop_front();
                x = nx, y = ny;
                if (cells.find({nx, ny}) == cells.end()) goto lbl;
            }
        }
        checked.emplace_back(x, y);
        cells[{x, y}] = j;
        dsu.add(x, y);
        colors.push_back(ask(x, y));

        for (auto [dx, dy] : vector<pair<int, int>>{
                {-1, -1},
                {-1, 0},
                {-1, +1},
                {0, -1},
                {0, +1},
                {1, -1},
                {1, 0},
                {1, +1},
        }) {
            auto it = cells.find({x + dx, y + dy});
            if (it != cells.end()) {
                if (colors[j] == colors[it->second]) {
                    dsu.merge(it->second, j);
                    if (dsu.size(dsu.find(j)) >= n) {
                        auto result = dsu.data[dsu.find(j)].second;
                        while (result.size() > n) {
                            result.pop_back();
                        }
                        cout << "! " << (colors[j] ? 'W' : 'B') << " ";
                        cout << result << endl;
                        dbg(k);
                        return;
                    }
                }
            } else {
                if (abs(dx) + abs(dy) <= 1) {
                    bool white = false;
                    bool black = false;
                    for (auto [dx2, dy2]: vector<pair<int, int>>{
                            {-1, -1},
                            {-1, 0},
                            {-1, +1},
                            {0,  -1},
                            {0,  +1},
                            {1,  -1},
                            {1,  0},
                            {1,  +1},
                    }) {
                        auto jt = cells.find({x + dx + dx2, y + dy + dy2});
                        if (jt != cells.end()) {
                            if (colors[jt->second]) {
                                white = true;
                            } else {
                                black = true;
                            }
                        }
                    }
                    if (white && black) {
                        q.emplace_back(x + dx, y + dy);
                    }
                }
            }
        }

        j++;
    }
}

int main() {
    int t = 1;
#if LOCAL
    freopen("../in.txt", "r", stdin);
    cin >> t;
#endif
    cin >> t;
    cin >> n;
    for (int i = 0; i < t; ++i) {
        solve();
    }
}
