#include <bits/stdc++.h>
using namespace std;
#define all(o) o.begin(), o.end()
using ll = long long;

#if LOCAL
#define dbg(o) ({ cout << #o << " = " << (o) << "\n"; o;})
#else
#define dbg(o) (o)
#endif

template<typename T, typename Q>
ostream &operator <<(ostream &o, const pair<T, Q> &x) {
    o << x.first << " " << x.second << "\n";
    return o;
}

template<typename T>
ostream &operator <<(ostream &o, const vector<T> &x) {
    for (const auto &v : x) {
        o << v << " ";
    }
    return o;
}


template<typename T>
istream &operator >>(istream &o, vector<T> &x) {
    for (auto &v : x) {
        o >> v;
    }
    return o;
}

template<typename T, typename Q>
ostream &operator <<(ostream &o, const unordered_map<T, Q> &x) {
    for (const auto &v : x) {
        o << v << " ";
    }
    return o;
}

static vector<vector<pair<int, int>>> dst;

int ilog2(int x) {
    return bit_width((unsigned)x) - 1;
}

template<typename I, typename J, typename C>
void f(I a, J result, int n, vector<int> &dp, C cmp) {
    int r = 0;
    int mn = n > 0 ? *a : 0;
    for (int i = 0; i < n; ++i) {
        int x = *(a + i);
        mn = max(mn, x, cmp);
        auto it = lower_bound(dp.begin(), dp.begin() + r, x, cmp);
        if (it == dp.begin() + r) {
            r++;
            dp[r - 1] = x;
        } else {
            *it = x;
        }
        *(result + i) = {r, mn};
    }
}

void solve() {
    int n, q;
    cin >> n >> q;
    vector<int> a(n);
    cin >> a;
    dst.assign(ilog2(n) + 1, vector(n, make_pair(0, 0)));
    for (int i = 0; i < n; ++i) {
        dst[0][i] = {1, a[i]};
    }
    int stride = 2;
    int depth = 0;
    vector<int> dp(n, 0);
    while (stride < n) {
        auto &row = dst[++depth];
        for (int i = 0; i < n; i += stride * 2) {
            int left = i;
            int center = min(i + stride, n);
            int right = min(center + stride, n);
            f(a.rend() - center, row.rend() - center, (center - left), dp, greater<int>());
            f(a.begin() + center, row.begin() + center, (right - center), dp, less<int>());
        }
        stride *= 2;
        dbg(row);
    }

    for (int i = 0; i < q; ++i) {
        int l, r;
        cin >> l >> r;
        l--;
        r--;
        if (l == r) {
            cout << "1\n";
            continue;
        }
        int k = ilog2(l ^ r);
        auto [a, min] = dst[k][l];
        auto [b, max] = dst[k][r];
        if (a == 1 && b == 1) {
            cout << (1 + (min < max)) << "\n";
        } else {
            cout << (int) ceil((a + b) * (2.0 / 3.0)) << "\n";
        }
    }
}

int main() {
    int t = 1;
#if LOCAL
    freopen("../in.txt", "r", stdin);
    cin >> t;
#endif
    cin >> t;
    for (int i = 0; i < t; ++i) {
        solve();
    }
}
