#include <iostream>
#include <vector>
#include <algorithm>
#include <bitset>
 
using namespace std;
 
constexpr int N = 1'000'001;

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
     
    int n; cin >> n;

    vector<string> op(n + 1);
    vector<string> s(n + 1);
    vector<int> v(n + 1);

    op[0] = "=";
    s[0] = "sync";
    v[0] = 0;

    for (int i = 1; i <= n; i++) {
        cin >> op[i] >> v[i] >> s[i];
    }

    vector<bitset<N>> shift(n + 1);
    shift[0].set(0);
    for (int i = 1; i <= n; i++) {
        if (op[i] =="+" && s[i] == "async") {
            shift[i] = shift[i - 1] | (shift[i - 1] << v[i]);
        } else {
            shift[i] = shift[i - 1];
        }
    }

    int should_shift = 0;
    for (int i = n; i >= 1; i--) {
        shift[i] <<= should_shift;
        if (op[i] == "+") {
            should_shift += v[i];
        }
    }

    bitset<N> total_shifts;
    for (int i = n; i > -1; i--) {
        if (op[i] == "=") {
            bitset<N> ans;
            if (s[i] == "sync") {
                ans = shift[i] << v[i];
            }

            for (int j = 0; j <= i; j++) {
                if (op[j] == "=" && s[j] == "async") {
                    ans = ans | (total_shifts << v[i]);
                }
            }

            cout << ans.count();
            return 0;
        }

        total_shifts |= shift[i];
    }

    return 0;
}