#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>

using namespace std;

string mult(string a, string b)
{
    reverse(a.begin(), a.end());
    reverse(b.begin(), b.end());
    std::vector<int> result(a.size() + b.size() + 1);
    for (int i = 0; i < a.size(); i++)
    {
        for (int j = 0; j < b.size(); j++)
        {
            int add = result[i + j];
            add += (a[i] - '0') * (b[j] - '0');
            result[i + j] = add % 10;
            result[i + j + 1] += add / 10;
        }
    }

    string res(a.size() + b.size() + 1, '0');
    for (int i = 0; i < result.size(); i++)
    {
        while (result[i] >= 10)
        {
            int add = result[i];
            result[i] = add % 10;
            result[i + 1] += add / 10;
        }
        res[i] = result[i] + '0';
    }
    while (res.back() == '0')
    {
        res.pop_back();
    }
    assert(res.size() > 0);
    reverse(res.begin(), res.end());
    return res;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    // cout << mult("1", "2") << endl;
    // cout << mult("1", "2") << endl;
    // cout << mult("239239", "987") << endl;
    // cout << mult("10", "10")<<endl;

    string s, c;
    cin >> s >> c;
    int middle = (s.size() + c.size()) / 2;
    for (int i = max(middle - 5, 1); i < min(middle + 6, (int)s.size()); i++)
    {
        string t1 = s.substr(0, i);
        string t2 = s.substr(i);
        if (mult(t2, c) == t1)
        {
            cout << t1 << " " << t2;
            return 0;
        }
    }

    return 0;
}