#include <bits/stdc++.h>

#define sz(v) (int) v.size()
#define all(v) v.begin(), v.end()
#define x first
#define y second

using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pii;

const int inf = 1e9;

struct Stack {
    vector<pair<pii, pii>> v;

    Stack() {}

    void add(pii x) {
        if (v.empty()) {
            v.emplace_back(x, x);
        } else {
            pii mn = v.back().second;
            v.emplace_back(x, min(x, mn));
        }
    }

    bool is_empty() {
        return sz(v) == 0;
    }

    pii top() {
        return v.back().first;
    }

    pii get_min() {
        return v.back().second;
    }

    void pop() {
        v.pop_back();
    }
};

struct Queue {
    Stack a, b;

    Queue() {}

    void add(pii x) {
        b.add(x);
    }

    void pop() {
        if (a.is_empty()) {
            while (!b.is_empty()) {
                pii x = b.top();
                b.pop();
                a.add(x);
            }
        }
        a.pop();
    }

    pii get_min() {
        pii mn = {inf, inf};
        if (!a.is_empty()) mn = min(mn, a.get_min());
        if (!b.is_empty()) mn = min(mn, b.get_min());
        return mn;
    }
};

const int H = 4e6;
const int K = 16;

int dp[H];
pii ls[H];

Queue qs[K + 2];

void precalc() {
    dp[0] = 0;
    fill(dp + 1, dp + H, inf);
    for (int h = 4; h < H; h += 4) {
        for (int x = 3; x <= K + 1; x++) {
            int s = (1 << x) * (x - 2);

            int to_pop = h - 4 - s - 4 * ((1 << (x - 2)) - 1);
            if (to_pop >= 0) {
                qs[x].pop();
                //cerr << x << " pop " << to_pop << "\n";
            }
            int to_add = h - s;
            if (to_add >= 0) {
                qs[x].add({dp[to_add], to_add});
                //cerr << x << " add " << to_add << "\n";
            }

            pii min_dp = qs[x].get_min();
            int value = max(1 + min_dp.first, x - 1);
            if (value < dp[h]) {
                dp[h] = value;
                ls[h] = {x, min_dp.second};
                //cerr << value << " from1 (" << x << ", " << min_dp.second << ")\n";
            }

            int ms = s + 4 * (1 << (x - 2));
            if (h - ms >= 0) {
                int value = max(1 + dp[h - ms], x);
                if (value < dp[h]) {
                    dp[h] = value;
                    ls[h] = {x, h - ms};
                    //cerr << value << " from2 (" << x << ", " << h - ms << ")\n";
                }
            }
        }
    }
}

int32_t main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif // LOCAL
    ios::sync_with_stdio(0);
    cin.tie(0);

    precalc();

    int n, k;
    cin >> n >> k;
    while (n--) {
        int h;
        cin >> h;
        if (h % 4 != 0) {
            cout << "-1\n";
            continue;
        }
        if (h >= H) {
            cout << "-1\n";
            continue;
        }
        bool ok = false;
        for (int k4 = 0; k4 < k; k4++) {
            if (h - k4 * 4 >= 0 && k4 + dp[h - k4 * 4] <= k) {
                h -= k4 * 4;
                vector<int> ans(k4, 4);
                while (h > 0) {
                    pii p = ls[h];
                    ans.push_back(1 << p.first);
                    h = p.second;
                }
                cout << sz(ans) << " ";
                for (int x : ans) cout << x << " ";
                cout << "\n";
                ok = true;
                break;
            }
        }
        if (!ok) cout << "-1\n";
    }

    return 0;
}

