#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>

using namespace std;
using ll = long long;
#define forn(i, n) for(ll i = 0; i < (n); ++i)

constexpr ll mod1 = 1e9 + 7, mod2 = 1e9 + 9;

ll bin_pow(ll x, ll p, ll mod) {
    ll res = 1;
    while (p) {
        if (p & 1) {
            res = res * x % mod;
        }
        x = x * x % mod;
        p /= 2;
    }
    return res;
}

ll inv(ll x, ll mod) {
    return bin_pow(x, mod - 2, mod);
}

ll div(ll x, ll y, ll mod) {
    return x * inv(y, mod) % mod;
}

void solve() {
    int x; cin >> x;
    if (x == 0) {
        cout << "0"; return;
    }
    string s;
    while (x) {
        s += ((x & 1) ? '1' : '0');
        x /= 2;
    }
    reverse(s.begin(), s.end());
   // cout << s << '\n';
    int n = s.size();
    vector<int> ans;
    bool fst = true;
    for (int i = n - 1; i >= 0; i -= 7) {
        string t;
        for (int j = std::max(0, i - 7 + 1); j <= i; ++j) {
            t += s[j];
        }
        while (t.size() < 7) {
            t = "0" + t;
        }
       // cout << t << '\n';
        if (!fst) {
            t = "1" + t;
        } else {
            t = "0" + t;
        }
        fst = false;

        int y = 0;
        for (auto c : t) {
            y = y * 2 + (c == '1' ? 1 : 0);
        }
        ans.push_back(y);
    }
    reverse(ans.begin(), ans.end());
    for (auto x : ans) cout << x << ' ';

}

int main() {
    int t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
}


