#include <iostream>
#include <algorithm>
#include <vector>
#include <cassert>

using namespace std;


using ll = long long;
#define forn(i, n) for(ll i = 0; i < (n); ++i)

constexpr ll mod1 = 1e9 + 7, mod2 = 1e9 + 9;

ll bin_pow(ll x, ll p, ll mod) {
    ll res = 1;
    while (p) {
        if (p & 1) {
            res = res * x % mod;
        }
        x = x * x % mod;
        p /= 2;
    }
    return res;
}

ll inv(ll x, ll mod) {
    return bin_pow(x, mod - 2, mod);
}

ll div(ll x, ll y, ll mod) {
    return x * inv(y, mod) % mod;
}

void solve() {
    string s, p;
    cin >> s >> p;

    auto n = s.size();

    constexpr ll SIZE = 1e5 + 1;

    auto for_mod = [](ll mod) {
        vector<ll> v(SIZE, 1);
        for(ll i = 1; i < SIZE; ++i) {
            v[i] = v[i - 1] * 10 % mod;
        }
        return v;
    };

    auto v1 = for_mod(mod1), v2 = for_mod(mod2);

    ll p_mod1 = 0, p_mod2 = 0;
    for (int i = p.size() - 1; i >= 0; --i) {
       p_mod1 = p_mod1 * 10 + p[i] - '0';
       p_mod1 %= mod1;

       p_mod2 = p_mod2 * 10 + p[i] - '0';
       p_mod2 %= mod2;                        
    }


    ll b_mod1 = 0, b_mod2 = 0;
    forn(i, n) {
        b_mod1 = (b_mod1 + v1[n - 1 - i] * (s[i] - '0')) % mod1;
        b_mod2 = (b_mod2 + v2[n - 1 - i] * (s[i] - '0')) % mod2;
    }

    ll a_mod1 = 0, a_mod2 = 0;
    forn(i, n) {
        a_mod1 = (a_mod1 * 10 + s[i] - '0') % mod1;
        a_mod2 = (a_mod2 * 10 + s[i] - '0') % mod2;

        b_mod1 = (mod1 + b_mod1 - v1[n - 1 - i] * (s[i] - '0') % mod1) % mod1;
        b_mod2 = (mod2 + b_mod2 - v2[n - 1 - i] * (s[i] - '0') % mod2) % mod2;


//        cout << a_mod1 << " " << b_mod1 << " " << div(a_mod1, b_mod1, mod1) << endl;
//        cout << a_mod2 << " " << b_mod2 << endl;

        if (div(a_mod1, b_mod1, mod1) == p_mod1 && div(a_mod2, b_mod2, mod2) == p_mod2) {
            cout << s.substr(0, i + 1) << " " << s.substr(i + 1, n) << "\n";
            return;
        }

    }

    assert(false);

}

int main() {
    int t = 1;
//    cin >> t;
    while (t--) {
        solve();
    }
}


