#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <array>
#include <set>
#include <iomanip>
#include <bitset>

using namespace std;
using ll = long long;
using ld = long double;

struct operat
{
	char c;
	ll v;
	bool async;
};

const ll N = 2000 * 500 + 1;

operat input()
{
	char c; cin >> c;
	ll v; cin >> v;
	string type; cin >> type;

	bool async = true;
	if (type == "sync")
	{
		async = false;
	}

	return { c, v, async };
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);

	ll n; cin >> n;

	vector<operat> ops(0);
	for (int i = 0; i < n; ++i)
	{
		ops.push_back(input());
	}

	vector<ll> suffsum(n + 1, 0);
	ll max_eq = -1;
	for (int i = n - 1; i >= 0; --i)
	{
		suffsum[i] = suffsum[i + 1];
		if (ops[i].c == '+')
		{
			suffsum[i] += ops[i].v;
		}
		else
		{
			max_eq = max(max_eq, i * 1ll);
		}
	}

	bitset<N> prefset;
	bitset<N> ans;
	prefset.set(0, true);

	vector<ll> eqs;

	for (int i = 0; i < n; ++i)
	{
		if (ops[i].c == '=' && ops[i].async)
		{
			eqs.push_back(ops[i].v);
		}

		if (max_eq <= i)
		{
			vector<ll> ceqs = eqs;
			if (ops[i].c == '=' && !ops[i].async)
			{
				ceqs.push_back(ops[i].v);
			}

			for (auto eqv : ceqs)
			{
				ans |= (prefset << (eqv + suffsum[i]));
			}
		}
		if (ops[i].c == '+' && ops[i].async)
			prefset |= (prefset << ops[i].v);
	}
	for (auto eqv : eqs)
	{
		ans |= (prefset << (eqv));
	}

	cout << ans.count() << '\n';


}
