#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <array>
#include <set>

using namespace std;
using ll = long long;

ll max_sum(ll m)
{
	return (1ll << m)* (m - 1);
}

ll min_sum(ll m)
{
	return (1ll << m) * (m - 2);
}

vector<ll> ans(ll k, ll sum)
{
	vector<ll> a = {};
	if (sum % 4)
	{
		return a;
	}

	while (k > 1 && sum > 0)
	{
		for (ll m = k + 1; m >= 2; --m)
		{
			ll maxs = max_sum(m);
			if (k + 1 == m)
			{
				maxs -= 4;
			}
			ll mins = min_sum(m);
			if (sum < mins)
			{
				continue;
			}
			else if (sum > maxs)
			{
				a.push_back((1ll << m));
				sum -= maxs;
				break;
			}
			else
			{
				a.push_back((1ll << m));
				sum = 0;
				break;
			}
		}
		--k;

	}
	return a;
	
}


int main()
{
	ll n, k;
	cin >> n >> k;

	for (int i = 0; i < n; ++i)
	{
		ll h; cin >> h;
		vector<ll> a = ans(k, h);
		if (a.empty())
		{
			cout << -1 << '\n';
		}
		else
		{
			cout << a.size() << " ";
			for (auto mem : a)
			{
				cout << mem << " ";
			}
			cout << '\n';
		}
	}

}
