#include <bits/stdc++.h>

using namespace std;

/* G draft
void dfs(int v, vector<vector<int> > &g, vector<int> &color, int col, int &sz, int &mx)
{
    color[v] = col;
    sz++;
    mx = max(mx, v);
    for (auto u : g[v]) if (color[u] == -1) {
        dfs(u, g, color, col, sz, mx);
    }
}

void solve()
{
    int n, m;
    cin >> n >> m;
    vector<vector<int> > g(n);
    for (int i = 0; i < m; i++) {
        int f, t;
        cin >> f >> t;
        f--, t--;
        g[f].push_back(t);
        g[t].push_back(f);
    }

    vector<int> color(n, -1);
    vector<int> maxForColor(n);
    int col = 0;
    for (int i = 0; i < n; i++) {
        if (color[i] == -1) {
            int sz = 0;
            int mx = -1;
            dfs(i, g, color, col, sz, mx);
            if (sz % 2 == 1) {
                cout << -1 << "\n";
                return;
            }
            maxForColor[col] = mx;
            col++;
        }
    }

    for (int i = 0; i < n; i++) {
        cout << maxForColor[color[i]] + 1 << " ";
    }
    cout << "\n";
}
*/

const long long M = 1000000000;
const int OPS = 20000000;
mt19937_64 rnd;

const int N = 2003;
double dp[N][N];
int init;

double dpFunc(int n, int k)
{
    if (dp[n][k] >= 0) {
        return dp[n][k];
    }
    if (k == 1) {
        return 1.0 * n / 2 + 0.5;
    }
    if (n == k) {
        return dp[n][k] = dpFunc(n - 1, k - 1) + 1;
    }
    double prob = 1.0 * (k - 1) / (n - 1);
    //cout << setprecision(20) << n << " " << k << " " << prob << "\n";
    //cout << setprecision(20) << "LEFT " << 1 << " " << prob << "\n";
    //cout << setprecision(20) << "RIGHT " << ((1 + prob) / 2) << " " << 1 - prob << "\n";
    return dp[n][k] = (dpFunc(n - 1, k - 1) + 1) * prob + (dpFunc(n - 1, k) + (1 + prob) / 2) * (1 - prob);
}

void solve()
{
    if (!init) {
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < N; j++) {
                dp[i][j] = -1;
            }
        }
        init = 1;
    }

    int n, k, d;
    cin >> n >> k >> d;
    cout << setprecision(20) << dpFunc(n, k) + 1.0 * n * (d - 1) / 2 << "\n";
    return;

    double base_ans = n * d / 2.0 + 0.5;

    double sum = 0;
    for (int i = 0; i < OPS; i++) {
        double cur = 0;
        int draw = k - 1;
        int rolls = n;

       // cout << setprecision(20) << cur << "\n";
        while (rolls > 0) {
            long long r = (rnd() % M + M) % M;
            double R = 1.0 * r / M * d;
            // printf("%.9f\n", R);
            cur += R;
            // cout << setprecision(20) << cur << "\n";

            if (cur - floor(cur) <= 1.0 * draw / (rolls - 1)) {
                draw--;
                sum += ceil(cur);
                cur = 0;
            }
            rolls--;
        }
        // cout << setprecision(20) << cur << " " << ceil(cur) << "\n";
        sum += ceil(cur);
        // cout << sum << " " << temp << "\n";
    }
    cout << setprecision(20) << sum / OPS << "\n";

    cout << setprecision(20) << base_ans << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    auto time1 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    auto time2 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    // cout << (time2 - time1) / 1e9 << "\n";
}