#include<bits/stdc++.h>
using namespace std;
#define int  long long
#define all(x) x.begin(), x.end()

const int inf= 1e9;
struct seg_tree{
    struct data{
        vector<int> lis_front, lis_back;
    };
    int n;
    vector<data> tree;
    vector<int> a;

    seg_tree(int _n, vector<int> &_a){
        n= _n; a= _a;
        tree.resize(4*n);
    }

    vector<int> get_lis_front(int l, int r){
        vector<int> dp(r - l + 1, inf), res(r - l, 0);
        dp[0]= 0;
        int cur_ans= 0;
        for(int i= 0; i < r - l; i++){
            int ind= upper_bound(all(dp), a[l + i]) - dp.begin();
            if(dp[ind] == inf) cur_ans++;
            dp[ind]= a[l + i];

            res[i]= cur_ans;
        }
        return res;
    }
    vector<int> get_lis_back(int l, int r){
        vector<int> dp(r - l + 1, inf), res(r - l, 0);
        dp[0]= -inf;
        int cur_ans= 0;
        for(int i= 0; i < r - l; i++){
            int ind= upper_bound(all(dp), -a[r - 1 - i]) - dp.begin();
            if(dp[ind] == inf) cur_ans++;
            dp[ind]= -a[r - 1 - i];

            res[i]= cur_ans;
        }
        return res;
    }

    void build_in(int v, int l, int r){
        tree[v].lis_front= get_lis_front(l, r);
        tree[v].lis_back= get_lis_back(l, r);

        /*
        cout << v << ": " << l << " " << r << "::::\n";
        for(auto x: tree[v].lis_front) cout << x << " ";
        cout << "\n";
        for(auto x: tree[v].lis_back) cout << x << " ";
        cout << "\n\n\n";
        */

        if(l + 1 == r) return;
        int m= (l + r) / 2;
        build_in(2*v, l, m);
        build_in(2*v + 1, m, r);
    }
    void build(){ build_in(1, 0, n); }

    pair<int, int> get_in(int v, int l, int r, int ql, int qr){
        // cout << l << " " << r << " :: " << ql << " " << qr << "\n";
        if(l + 1 == r) return {1, 1};

        int m= (l + r) / 2;
        if(ql < m && m < qr){
            pair<int, int> p{tree[2*v].lis_back[m - 1 - ql], tree[2*v + 1].lis_front[qr - 1 - m]};
            if(p.first == 1 && p.second == 1 && a[m - 1] > a[m]) return {1, 1};
            return p;
        }
        if(qr <= m) return get_in(2*v, l, m, ql, qr);
        if(m <= ql) return get_in(2*v + 1, m, r, ql, qr);
    }
    int get_aprox(int ql, int qr){
        auto [m1, m2]= get_in(1, 0, n, ql, qr);

        if(m1 == 1 && m2 == 1) return 1;
        return 3*max(m1, m2) / 2;
    }
};

void solve(){
    int n, q; cin >> n >> q;
    vector<int> per(n);
    for(auto &x: per) cin >> x;

    seg_tree t(n, per);
    t.build();
    while(q--){
        int l, r; cin >> l >> r; l--;
        cout << t.get_aprox(l, r) << " ";
    } cout << "\n";
}

signed main(){
ios_base::sync_with_stdio(0);
cin.tie(0);
    int _; cin >> _;
    while(_--) solve();
}