#include <iostream>
#include <vector>
#include <set>
#include <string>

using namespace std;

using ll = long long;

struct tree {
	ll cur;
	tree** next;
	tree() : cur(0), next(new tree*[26]) {
		for (int i = 0; i < 26; i++) next[i] = nullptr;
	}

	void add(string& s, int start = 0)
	{
		if (start == s.size())
		{
			cur++;
			return;
		}

		if (next[s[start] - 'a'] == nullptr) next[s[start] - 'a'] = new tree();
		next[s[start] - 'a']->add(s, start + 1);
	}

};
using ptree = tree *;

ll* get(ptree t, string& s, int start = 0)
{
	if (start == s.size()) return &(t->cur);

	auto n = t->next[s[start] - 'a'];
	if (n == nullptr) return nullptr;
	return get(n, s, start + 1);
}

auto test_case() -> void {
	int n; cin >> n;
	vector<string> input_1, input_2;
	input_1.reserve(n); input_2.reserve(n);
	tree pos_1{}, pos_2{};

	for (int i = 0; i < n; i++) {
		string s_1, s_2; cin >> ws >> s_1 >> ws >> s_2;
		input_1.push_back(s_1);
		input_2.push_back(s_2);

		pos_1.add(s_1);
		pos_2.add(s_2);
	}

	for (int i = 0; i < n; i++) {
		(*get(&pos_1, input_1[i]))--;
		(*get(&pos_2, input_2[i]))--;
		if (i == 0) continue;
		string& prev_1 = input_1[i - 1];
		string& prev_2 = input_2[i - 1];
		if (prev_1 == input_1[i]) continue;
		if (prev_2 == input_2[i]) continue;
		//no match
		if (
			(*get(&pos_1, prev_1)) > 0 ||
			(*get(&pos_2, prev_2)) > 0
		) {
			cout << "No\n";
			return;
		}
	}
	cout << "Yes\n";
}

int main()
{
	int t; cin >> t;
	for (int i = 0; i < t; i++)
		test_case();

	return 0;
}