#include <iostream>
#include <cmath>
#include <string>
#include <vector>
#include <algorithm>
#include <numeric>

#include <complex>
#include <vector>
using namespace std;

typedef long long ll;
typedef complex<double> C;
typedef vector<double> vd;
typedef vector<int> vi;
typedef vector<ll> vl;

void fft(vector<C>& a) {
    int n = a.size(), L = 31 - __builtin_clz(n);
    static vector<complex<long double>> R(2, 1);
    static vector<C> rt(2, 1);
    for (static int k = 2; k < n; k *= 2) {
        R.resize(n); rt.resize(n);
        auto x = polar(1.0L, acos(-1.0L) / k);
        for (int i = k; i < 2 *k; i++) {
            rt[i] = R[i] = i&1 ? R[i/2] * x : R[i/2];
        }
    }
    vi rev(n);
    for (int i = 0; i < n; i++) {
        rev[i] = (rev[i / 2] | (i & 1) << L) / 2;
    }
    for (int i = 0; i < n; i++) {
        if (i < rev[i] ) {
            swap(a[i], a[rev[i]]);
        }
    }
    for (int k = 1; k < n; k *= 2) {
        for (int i = 0; i < n; i += k * 2) 
        {
            for (int j = 0; j < k; j++) {
                C z = rt[j + k] * a[i + j + k];
                a[i + j + k] = a[i + j] - z;
                a[i + j] += z;
            }
        }
        
    }
}

vd conv(const vd& a, const vd& b) {
    if (a.empty() || b.empty()) return {};
    vd res(a.size() + b.size() - 1);
    int L = 32 - __builtin_clz(res.size()), n = 1 << L;
    vector<C> in(n), out(n);
    copy(a.begin(), a.end(), begin(in));
    for (int i = 0; i < b.size(); i++) {
        in[i].imag(b[i]);
    }
    fft(in);
    for (C& x : in) x *= x;
    for (int i = 0; i < n; i++)
    {
        out[i] = in[-i & (n - 1)] - conj(in[i]);
    }
    fft(out);
    for (int i = 0; i < res.size(); i++)
    {
        res[i] = imag(out[i]) / (4 * n);
    }
    return res;
}

bool check(vd as, vd bs, vd cs) {
    vd rs = conv(as, bs);
    vl res(rs.size());
    for (int i = 0; i < rs.size(); i++)  {
        res[i] = round(rs[i]);
    }
    ll carry = 0;
    // for (double i : res) cout << i << ' ';
    // cout << '\n';
    for (int i = res.size(); i--;)  {
        // cout << i << ' ' << res[i] << ' ' << carry << '\n';
        ll temp = res[i] / 10;
        if (res[i] + (carry % 10) >= 10) {
            // cout << "A " << (ll)res[i] % 10 << ' '  << carry % 10 << ' ' << (ll)res[i] % 10 + carry % 10 << '\n';
            if (((ll)res[i] % 10 + carry % 10) >= 10) {
                temp++;
            }
            // cout << "AAA " << res[i] <<  ' ' << carry % 10 << ' ' << (res[i] + (carry % 10)) << '\n';
            res[i] = (ll)(res[i] + carry % 10) % 10;
        } else {
            res[i] += carry % 10;
        }
        carry /= 10;
        carry += temp;
    }
    while (carry != 0)  {
        res.insert(res.begin(), carry % 10);
        carry /= 10;
    }
    
    // for (double i : res) cout << i << ' ';
    // cout << '\n';
    if (res.size() != cs.size()) return false;
    for (int i = 0; i < cs.size(); i++) {
        if (cs[i] != res[i]) return false;
    }
    return true;
}

void solve() {
    string s, a, b, c;
    cin >> s >> c;
    int x = s.size(), y = c.size();
    vd cs(y);
    for (int i = 0; i < y; i++) cs[i] = c[i] - '0';
    for (int k = max((x + y) / 2 - 10, 1); k < min((x + y) / 2 + 10, x); k++) {
        vd as(k);
        vd bs(x - k);
        for (int i = 0; i < k; i++) as[i] = s[i] - '0';
        for (int i = 0; i < x - k; i++) bs[i] = s[i + k] - '0';
        // cout << k << '\n';
        // for (int i : as) cout << i << ' ';
        // cout << '\n';
        // for (int i : bs) cout << i << ' ';
        // cout << '\n';
        // cout << "---------------\n";
        if (check(cs, bs, as)) {
            // cout << "SOLUTION\n";
            for (int i : as) cout << i;
            cout << ' ';
            for (int i : bs) cout << i;
            cout << '\n';
            return;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false), cin.tie(0);
    #ifdef LOCAL
        freopen("input.in", "r", stdin);
    #endif
    int t = 1;
    // cin >> t;
    while(t--) {
        solve();
    }
}