#include <iomanip>
#include <iostream>
#include <vector>
#include <algorithm>
#include <map>
#include <set>

using namespace std;
using ll = long long;

template<typename T>
istream& operator >> (istream& in, vector<T>& vec) {
    for (auto&& e :vec) {
        in >> e;
    }
    return in;
}

template<typename T>
bool maxi(T& a, T b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool mini(T& a, T b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

/*
 *
 */


struct gate {
    int g, k;

    gate(int g, int k) : g(g), k(k) {}
    gate() : g(0), k(0) {}

    friend istream& operator >> (istream& in, gate& g) {
        in >> g.k >> g.g;
        return in;
    }

    bool operator < (const gate& other) const {
        return make_pair(g, k) < make_pair(other.g, other.k);
    }
};

constexpr int INF = 1e9;

void solve() {
    int n, s, h;
    cin >> n >> s >> h;
    vector<gate> ingate(n);
    cin >> ingate;
    if (s > h) {
        s *= -1;
        h *= -1;
        for (auto& e :ingate) {
            e.g *= -1;
            e.k *= -1;
        }
    }

    vector<gate> right;
    vector<gate> left;
    for (auto e : ingate) {
        if (e.g > s) {
            if (e.g < h) {
                right.push_back(e);
            }
        } else {
            left.push_back(e);
        }
    }

    std::sort(right.begin(), right.end());
    std::sort(left.rbegin(), left.rend());

    vector<gate> right2;
    int prev = s;
    for (auto e :right) {
        if (e.k > e.g) {
            cout << -1;
            return;
        }
        if (e.k >= prev) {
            continue;
        }
        prev = e.k;
        right2.push_back(e);
    }

    right = right2;
    if (right.empty()) {
        cout << h - s;
        return;
    }

    int mn = right.back().k;
    vector<gate> left2;
    prev = s;
    for (auto e :left) {
        if (e.g < mn) {
            continue;
        }
        if (e.k < e.g) {
            cout << -1;
            return;
        }
        if (e.k < prev) {
            continue;
        }
        prev = e.k;
        left2.push_back(e);
    }

    int want = h;
    ll ans = 0;
    while (true) {
        if (want > s) {
            if (right.empty()) {
                ans += want - s;
                break;
            }
            gate cur = right.back();
            while (!left.empty() && left.back().g < cur.k) {
                left.pop_back();
            }
            if (!left.empty() && left.back().k > cur.g) {
                cout << -1;
                return;
            }
            int w = cur.k;
            ans += want - w;
            want = w;
        } else {
            if (left.empty()) {
                ans += s - want;
                break;
            }

            gate cur = left.back();
            while (!right.empty() && right.back().g > cur.k) {
                right.pop_back();
            }
            if (!right.empty() && right.back().k < cur.g) {
                cout << -1;
                return;
            }
            int w = cur.k;
            ans += w - want;
            want = w;
        }
    }
    cout << ans;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

#ifdef BOBR
    freopen("../input.txt", "r", stdin);
    freopen("../output.txt", "w", stdout);
#endif

    int t = 1;
    cin >> t;
    while (t--) {
        solve();
        cout << '\n';
    }
}