#include <bits/stdc++.h>

#define int i64
using namespace std;
using i64 = int64_t;
mt19937 rnd(42);

struct DSU {
    vector<int> p, w;
    int mx = 1;

    DSU(int n) {
        p.resize(n);
        w.resize(n);
        for (int i = 0; i < n; i++) {
            p[i] = i;
            w[i] = 1;
        }
    }

    int get(int x) {
        if (x == p[x]) return x;
        return p[x] = get(p[x]);
    }

    void join(int x, int y) {
        x = get(x);
        y = get(y);
        if (x == y) return;
        if (w[x] > w[y]) swap(x, y);
        w[y] += w[x];
        p[x] = y;
        mx = max(w[y], mx);
    }

    int maxim() {
        return mx;
    }
};

int dx[8] = {-1, -1, -1, 1, 1, 1, 0, 0};
int dy[8] = {1, 0, -1, 1, 0, -1, 1, -1};
map<pair<int, int>, int> col;
map<pair<int, int>, int> num;
map<pair<int, int>, int> comp;
vector<vector<pair<int, int>>> coms;
int co = 0;

void dfs(int x, int y) {
    comp[{x, y}] = co;
    coms.back().push_back({x, y});
    for (int i = 0; i < 8; i++) {
        int nx = x + dx[i];
        int ny = y + dy[i];
        if (col.find({nx, ny}) != col.end() and col[{nx, ny}] == col[{x, y}] and comp.find({nx, ny}) == comp.end()) {
            dfs(nx, ny);
        }
    }
}

int q = 0;
int curnu = 0;
DSU a(50000);

void query(int x, int y) {
    q++;
    if (q >= 30000) {
        exit(1);
    }
    cout << "? " << x << " " << y << endl;
    char res;
    cin >> res;
    if (res == '0') {
        exit(1);
    }
    if (res == 'B') {
        col[{x, y}] = 0;
    } else {
        col[{x, y}] = 1;
    }
    num[{x, y}] = curnu;
    for (int i = 0; i < 8; i++) {
        int nx = x + dx[i];
        int ny = y + dy[i];
        if (col.find({nx, ny}) != col.end() and col[{x, y}] == col[{nx, ny}]) {
            a.join(num[{nx, ny}], curnu);
        }
    }
    curnu++;
}

int n;

void solve() {
    co = 0;
    curnu = 0;
    col.clear();
    num.clear();
    comp.clear();
    coms.resize(0);
    a = DSU(50000);
    int xx = 0;
    int yy = 0;
    query(xx, yy);
    for (int r = 1; r <= 1000; r++) {
        yy++;
        for (int i = 0; i < r; ++i) {
            if (a.maxim() >= n) {
                break;
            }
            query(xx, yy);
            yy--;
            xx--;
        }
        for (int i = 0; i < r; ++i) {
            if (a.maxim() >= n) {
                break;
            }
            query(xx, yy);
            yy--;
            xx++;
        }
        for (int i = 0; i < r; ++i) {
            if (a.maxim() >= n) {
                break;
            }
            query(xx, yy);
            yy++;
            xx++;
        }
        for (int i = 0; i < r; ++i) {
            if (a.maxim() >= n) {
                break;
            }
            query(xx, yy);
            yy++;
            xx--;
        }
    }
    for (auto e: col) {
        auto [x, y] = e.first;
        if (comp.find(make_pair(x, y)) == comp.end()) {
            coms.push_back(vector<pair<int, int>>(0));
            dfs(x, y);
            co++;
            if (coms.back().size() >= n) {
                cout << "! ";
                if (col[{x, y}] == 0) cout << "B ";
                else cout << "W ";
                for (int i = 0; i < n; i++) {
                    cout << coms.back()[i].first << " " << coms.back()[i].second << " ";
                }
                cout << endl;
                return;
            }
        }
    }
    exit(1);
}

signed main() {
    int t = 1;
    cin >> t;
    cin >> n;
    while (t--)
        solve();
}
