#include <bits/stdc++.h>

using namespace std;

#define int long long

using pii = pair<int, int>;
using vpi = vector<pii>;

map<pii, pii> king;
map<pii, vpi> component;
map<pii, int> color;

void unite(pii k1, pii k2) {
    if (k1==k2)return;
    for (auto& el : component[k2]) {
        component[k1].emplace_back(el);
        king[el] = k1;
    }
    component.erase(k2);
}

pii select(pii k) {
    vector<pii> to_select;

    int LIMIT_TO_SELECT = 15;

    for (auto& [x, y] : component[k]) {
        for (auto dx : {-1, 0, 1}) {
            for (auto dy : {-1,0, 1}) {
                if (dx == 0 && dy == 0) continue;
                if (color.find(make_pair(x+dx,y+dy))!=color.end()) continue;
                to_select.emplace_back(x+dx, y+dy);
            }
        }
        if (to_select.size() > LIMIT_TO_SELECT) {
            break;
        }
    }

    int random_idx = rand() % to_select.size(); // TODO: maybe rng?

    return to_select[random_idx];
}

void ask(pii to_ask) {
    cout << "? " << to_ask.first << " " << to_ask.second << std::endl;
    string s;
    cin >> s;
    if (s == "0") {
        exit(0);
    }
    if (s == "B") {
        color[to_ask] = 1;
    } else {
        color[to_ask] = 2;
    }
}

void solve(int n) {
    ask(make_pair(0, 0));
    component[{0, 0}].emplace_back(0, 0);
    king[{0, 0}] = {0, 0};

    while (true) {
        pii mx_king = component.begin()->first;
        int mx_sz = component[mx_king].size();
        for (const auto& [k, c] : component) {
            if (c.size() > mx_sz) {
                mx_king = k;
                mx_sz = c.size();
            }
        }

        if (mx_sz >= n) {
            if (color[mx_king] == 1) {
                cout << "! B ";
            } else {
                cout << "! W ";
            }
            int sz = 1;
            set<pii>used;
            set<pii> storage; for (auto& el : component[mx_king]) {
                storage.insert(el);
            }

            used.insert(component[mx_king][0]);

            while (sz < n) {
                for (auto& el : used) {
                    auto [x, y] = el;
                    for (auto dx : {-1,0,1}) {
                        for (auto dy : {-1, 0, 1}) {
                            auto kek = make_pair(x+dx, y+dy);
                            if (storage.contains(kek) && !used.contains(kek) && sz < n) {
                                used.insert(kek);
                                sz++;
                            }
                        }
                    }
                }
            }

            for (auto & [x, y] : used) {
                cout << x << " " << y << " ";
            }

            cout << endl;
            return;
        }

        pii to_select = select(mx_king);

        king[to_select] = to_select;
        component[to_select].push_back(to_select);
        ask(to_select);
        for (auto dx : {-1,0, 1}) {
            for (auto dy : {-1,0, 1}) {
                if (dx == 0 && dy == 0) continue;

                pii kek = make_pair(to_select.first+dx, to_select.second+dy);
                if (color.find(kek) != color.end() && color[kek] == color[to_select]) {
//                    if (to_select.first == -1 && to_select.second == 1) {
//                        cout  << "ALERT!!! " << kek.first << " " << kek.second << endl;
//                        cout << "ALERT! " << king[to_select].first << " " << king[to_select].second << endl;
//                        cout << "ALERT!!! " << king[kek].first << " " << king[kek].second;
//                    }
                    unite(king[to_select], king[kek]);
                }
            }
        }

//        cout << "debug " << component.size( ) <<  " = " << endl;
//        for(auto&[k,c]:component) {
//            cout << k.first << " " << k.second << " " << c.size() << endl;
//        }
//        cout << "-----------" << endl;
//       cout << "`````" << endl;
//        cout << component.size() << endl;
//        for (auto& [k, c] : component) {
//            cout << k.first << " " << k.second << " " << c.size() << endl;
//        }
//        cout << "`````" << endl;
    }
}

void clearall() {
    king.clear();
    component.clear();
    color.clear();
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int nt = 1;
    cin >> nt;
    int n;
    cin >> n;
    while (nt--) {
        solve(n);
        clearall();
    }
}
