#pragma GCC optimize("O3")
#pragma target("avx2")
#include<iostream>
#include<vector>
#include<map>
#include<set>
#include<iomanip>
#include<deque>
#include <bitset>

using namespace std;

struct S {
    char op;
    int value;
    bool async;
};

void solve() {
    int n;
    cin >> n;
    vector<S> a;
    a.reserve(n);
    for (int i = 0; i < n; i++) {
        char op_;
        int value_;
        std::string async_;
        cin >> op_ >> value_ >> async_;
        a.push_back({op_, value_, async_ == "async"});
    }

    int last_eq = -1;
    for (int i = 0; i < n; i++) {
        if (a[i].op == '=') {
            last_eq = i;
        }
    }

    int s = 0;
    if (last_eq != -1) {
        for (int i = last_eq; i < n; i++) {
            s += a[i].value;
        }
    } else {
        cout << 1;
        return;
    }

    bitset<1'000'000 + 1> pre_dp;
    pre_dp[s] = true;

    for (int i = 0; i < last_eq; i++) {
        if (a[i].op == '+' && a[i].async) {
            pre_dp = pre_dp | (pre_dp << a[i].value);
        }
    }

    vector<int> async_eqs;
    for (int i = 0; i <= last_eq; i++) {
        if (a[i].op == '=' && a[i].async) {
            async_eqs.push_back(a[i].value);
        }
    }
    bitset<1'000'000+1> sync_dp = pre_dp;
    if(async_eqs.size() == 0) {
        cout << sync_dp.count();
        return;
    }

    bitset<1'000'000 + 1> ans_dp = sync_dp;
    bitset<1'000'000 + 1> async_dp = sync_dp >> a[last_eq].value;
    bitset<1'000'000+1> eq_dp = async_dp;
    for (int i = last_eq + 1; i < n; i++) {
        if(a[i].async)
            eq_dp |= (eq_dp >> a[i].value);
        else {
            async_dp |= eq_dp;
            eq_dp >>= a[i].value;
        }
    }
    async_dp |= eq_dp;

    for (int cur_eq : async_eqs) {
        ans_dp |= async_dp << cur_eq;
    }
    cout << ans_dp.count();
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int t = 1;
    while(t--) {
        solve();
    }
}