// Gletcher Gang 2025 (Khramtsov, Sarycheva, Khramtsov, Laukhin, Khramtsov,
// Khramtsov, Khramtsov)

#include <algorithm>
#include <iostream>
#include <numeric>
#include <unordered_map>
#include <vector>

using namespace std;

void solve() {
  int n;
  cin >> n;
  vector<string> w1(n), w2(n);
  unordered_map<string, int> mp1, mp2;

  mp1.rehash(n);
  mp2.rehash(n);

  for (int i = 0; i < n; i++) {
    cin >> w1[i] >> w2[i];
    mp1[w1[i]] = i;
    mp2[w2[i]] = i;
  }

  bool ok = true;
  for (int i = 1; i < n; i++) {
    if (w1[i] == w1[i - 1] || w2[i] == w2[i - 1]) {
      continue;
    }

    if (mp1[w1[i - 1]] >= i || mp2[w2[i - 1]] >= i) {
      ok = false;
      break;
    }
  }

  cout << (ok ? "Yes\n" : "No\n");
}

int main() {
  cin.tie(nullptr)->sync_with_stdio(false);
  int tt;
  cin >> tt;
  while (tt--) {
    solve();
  }
}