#include <bits/stdc++.h>

using namespace std;
using ll = long long;

constexpr ll kInf = 1e18, kMaxN = 1e5;

#define all(v) v.begin(), v.end()

template<typename T>
istream& operator>>(istream& is, vector<T>& v) {
    for (auto& i : v) {
        is >> i;
    }
    return is;
}
/*

ll sz[kMaxN], p[kMaxN];
vector<ll> g[kMaxN];

ll get(ll v) {
    return p[v] == v ? v : p[v] = get(p[v]);
}

ll join(ll u, ll v) {
    u = get(u), v = get(v);
    if (u == v) return 0;
    if (sz[u] < sz[v]) swap(u, v);

    sz[u] += sz[v];
    p[v] = u;
    return 1;
}


int cur_c = 1;
vector<int> c;
int dfs(int v) {
    int cnt = 0;
    for (auto u : g[v]) {
        cnt += dfs(v);
    }
    if (cnt % 2 == 1) {
        c[v] = cur_c++;
        return 0;
    }

    return 1;
}

void solve() {
    ll n, m;
    cin >> n >> m;
    c.resize(n);

    for (int i = 0; i < n; ++i) {
        sz[i] = 1;
        p[i] = i;
    }

    vector<vector<ll>> e;
    for (int i = 0; i < m; ++i) {
        ll u, v;
        cin >> u >> v;
        --v, --u;
        if (join(u, v)) {
            g[v].push_back(u);
            g[u].push_back(v);
        }
    }

    cout << "!" << endl;

    if (n % 2 == 1) {
        cout << "-1\n";
    } else {
        if (!dfs(0)) {
            for (auto i : c) cout << i << " ";
            cout << "\n";
        }
    }
}
*/

void solve() {
    int n; cin >> n;
    multiset<pair<char, char>> s;
    vector<vector<char>> a(n, vector<char>(2));
    for (int i = 0; i < n; i++) {
        string s1, s2; cin >> s1 >> s2;
        a[i] = {s1[0], s2[0]};
        s.insert({s1[0], '#'});
        s.insert({'#', s2[0]});
    }

    int fl = 1;
    for (int i = 1; i < n; i++) {
        s.erase(s.find(make_pair(a[i-1][0], '#')));
        s.erase(s.find(make_pair('#', a[i-1][1])));
        if (a[i][0] == a[i - 1][0] or a[i][1] == a[i - 1][1]) continue;
        if (s.find(make_pair(a[i - 1][0], '#')) == s.end() and
                s.find(make_pair( '#', a[i - 1][1])) == s.end()) {
            continue;
        }

        fl = 0;
        //cout << i << " ";
        break;
    }

    cout << (fl ? "Yes\n" : "No\n");

}

//void solve() {
//    ll a, b, c;
//    cin >> a >> b >> c;
//
//    vector<vector<ll>> v = {{a, 2}, {b, 1}, {c, 0}};
//    ranges::sort(v);
//
//    a = v[0][0];
//    b = v[1][0];
//    c = v[2][0];
//
//    if (c > a + b) {
//        cout << "No\n";
//        return;
//    }
//    string s;
//    for (int i = 0; i < 2; ++i) {
//        s += "x";
//    }
//    vector<pair<ll, string>> ans;
//    ans.emplace_back(v[0][1], s);
//    for (int i = 0; i < a; ++i) {
//        s += "y";
//    }
//    ans.emplace_back(v[2][1], s);
//    for (int i = 0; i < c - a; ++i) {
//        s += "z";
//    }
//
//    ll x = c - a;
//    for (int i = 2; x != b; ++i, ++x) {
//        s[i] = 'a';
//    }
//
//    ans.emplace_back(v[2][1], s);
//    ranges::sort(ans);
//    cout << "YES\n";
//    for (int i = 0; i < 3; ++i) {
//        cout << ans[i].second << '\n';
//    }
//}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    ll iter = 1;
    cin >> iter;

    while (iter--) {
        solve();
    }
    return 0;
}