#include <bits/stdc++.h>

using namespace std;

#define ll long long

const int INF = 1e9;
const int MAX_INT = 1e9 - 1;
const ll NEXT_INT = 1e9;
const int BLOCK_SIZE = 9;

struct Block {
    int x;
    int len;
};

struct Num {
    vector<Block> blocks;

    Num() {
        blocks = {{0, 0}};
    }

    Num(const string& s) {
        int n = (s.size() + BLOCK_SIZE - 1) / BLOCK_SIZE;
        blocks.resize(n);
        for (int i = 0; i < n; ++i) {
            int start = BLOCK_SIZE * i;
            int len = min(static_cast<int>(s.size()) - start, BLOCK_SIZE);
            auto str_x = s.substr(start, len);
            blocks[i].x = stoi(str_x);
            blocks[i].len = str_x.size();
        }
    }

    std::pair<string, ll> div(int c) {
        ll rest = 0;
        string res;
        for (int i = 0; i < blocks.size(); ++i) {
            ll cur = rest * NEXT_INT + blocks[i].x;
            if (rest == 0) {
                string tmp = to_string(cur);
                int pp = blocks[i].len - tmp.size();
                for (int j = 0; j < pp; ++j) {
                    res += '0';
                }
            }

            string blk_str = to_string(cur / c);
            res += blk_str;
            rest = cur % c;
        }
        return {res, rest};
    }
};

pair<string, ll> div(string& a, int c) {
    string res;

    ll cur = 0;
    int i = 0;
    while (i < a.size() && cur < c) {
        cur = cur * 10 + a[i++] - '0';
    }

    res = to_string(cur / c);
    cur = cur % c;
    while (i < a.size()) {
        cur = cur * 10 + a[i++] - '0';
        if (cur < c) {
            res += '0';
        } else {
            res += to_string(cur / c);
            cur = cur % c;
        }
    }

    return {res, cur};
}

pair<int, int> try_div(string& s, int m, int c) {
    string a = s.substr(0, m);
    string b = s.substr(m, s.size() - m);

    auto [dv, rest] = div(a, c);

//    cout << a << '\n' << dv << '\n' << b << endl << endl;

    if (dv.size() < b.size()) {
        return {-1, rest};
    }
    if (dv.size() > b.size()) {
        return {1, rest};
    }

    for (int i = 0; i < dv.size(); ++i) {
        if (dv[i] < b[i]) {
            return {-1, rest};
        }
        if (dv[i] > b[i]) {
            return {1, rest};
        }
    }
    return {0, rest};
}

void print_ans(string& s, int m) {
    string a = s.substr(0, m);
    string b = s.substr(m, s.size() - m);

    cout << a << ' ' << b << endl;
}

void solve() {
    string s;
    int c;
    cin >> s >> c;

    int l = 1;
    int r = s.size();
    while (l < r) {
        int m = (l + r) / 2;
        auto [res, rest] = try_div(s, m, c);
        if (res == -1) {
            l = m + 1;
        } else {
            r = m;
        }
    }
}

int main() {
    solve();

    return 0;
}