#include <bits/stdc++.h>

using namespace std;

#define int int64_t
#define vi vector<int>
#define vb vector<bool>
#define graph vector<vector<int>>
#define pb push_back

void dfs1(int u, graph &g, vb &vis, int &sz) {
    sz++;
    vis[u] = true;
    for (auto v : g[u]) {
        if (!vis[v]) {
            vis[v] = true;
            dfs1(v, g, vis, sz);
        }
    }
}

void dfs2(int u, graph &g, vb &vis, vi &d, vi &from, vector<pair<int,int>> &p, vb &picked) {
    vis[u] = true;
    bool is_leaf = false;
    for (auto v : g[u]) {
        if (!vis[v]) {
            is_leaf = true;
            vis[v] = true;
            from[v] = u;
            dfs2(v, g, vis, d, from, p, picked);
        }
    }

    if (!d[u]) {
        p.emplace_back(u, from[u]);
        d[from[u]] = (d[from[u]] + 1) % 2;
    }
}

int solve() {
    int n,m;
    cin >> n >> m;
    graph g(n);
    for (int i = 0;i < m;i++) {
        int u,v;
        cin >> u >> v;
        u--;v--;

        g[u].pb(v);
        g[v].pb(u);
    }

    bool correct = true;
    vb vis1(n), vis2(n), picked(n);
    vi c(n), d(n), from(n);
    vector<pair<int,int>> p;

    for (int i = 0;i < n;i++) {
        if (!vis1[i]) {
            int sz = 0;
            dfs1(i, g, vis1, sz);
            if (sz % 2) {
                correct = false;
                break;
            }
            dfs2(i, g, vis2, d, from, p, picked);
        }
    }

    if (!correct) cout << -1 << endl;
    else {
        int clr = 0;
        for (auto [u, v] : p) {
            if (!c[u] && !c[v]) {
                clr++;
                c[u] = clr;
                c[v] = clr;
            } else {
                c[u] = max(c[u], c[v]);
                c[v] = max(c[u], c[v]);
            }
        }

        for (auto clr : c) cout << clr << " ";
        cout << endl;
    }

    return 0;
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}