#include <iostream>
#include <vector>
#include <algorithm>

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    unsigned int n;
    if (!(std::cin >> n)) return 0;

    if (n == 0) {
        std::cout << 0 << std::endl;
        return 0;
    }

    std::vector<int> encoding;
    
    while (n > 0) {
        int byte_data = n & 0x7F; 
        n >>= 7;
        
        if (encoding.empty()) {
            encoding.push_back(byte_data); 
        } else {
            encoding.push_back(byte_data | 0x80); 
        }
    }
    
    std::reverse(encoding.begin(), encoding.end());

    for (size_t i = 0; i < encoding.size(); ++i) {
        std::cout << encoding[i] << (i == encoding.size() - 1 ? "" : " ");
    }
    std::cout << std::endl;

    return 0;
}