import sys

def solve_compact_encoding(n):
    
    if n == 0:
        return [0]

    # Use a list to store the encoded bytes
    encoding = []
    
    # The encoding is big-endian, so we process the least significant 7-bit chunks 
    # first and then reverse the list.
    while n > 0:
        # Get the least significant 7 bits (the data payload)
        byte_data = n & 0x7F
        
        # Shift n to the right by 7 bits to prepare for the next chunk
        n >>= 7
        
        # If the list is empty, this is the first (and therefore last) byte, 
        # so the continuation bit (0x80) is not set.
        # Otherwise, the continuation bit is set (0x80 = 10000000 in binary)
        if not encoding:
            # First byte is the last byte in the sequence (continuation bit 0)
            encoding.append(byte_data) 
        else:
            # All subsequent bytes are continuation bytes (continuation bit 1)
            encoding.append(byte_data | 0x80) 

    # The problem specifies big-endian, meaning the most significant bits come first.
    # Since we processed LSBs first, we reverse the list.
    encoding.reverse()

    return encoding

if __name__ == "__main__":
    # Read the single integer n from standard input
    try:
        # sys.stdin.read().strip() handles input safely, including from redirection
        input_line = sys.stdin.read().strip()
        if not input_line:
            # Handle empty input
            exit()
            
        # The input is an unsigned 32-bit integer, so we read it as a standard integer
        n = int(input_line)
        
    except EOFError:
        exit()
    except ValueError:
        # Handle non-integer input
        exit()
    
    # Solve the problem
    result = solve_compact_encoding(n)
    
    # Print the sequence of integers separated by a space
    print(*(result))