#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

string multiply(string num1, string num2) {
    if (num1 == "0" || num2 == "0") return "0";
    
    int n1 = num1.size();
    int n2 = num2.size();
    
    vector<int> result(n1 + n2, 0);
    
    for (int i = n1 - 1; i >= 0; i--) {
        int carry = 0;
        int d1 = num1[i] - '0';
        for (int j = n2 - 1; j >= 0; j--) {
            int d2 = num2[j] - '0';
            int sum = d1 * d2 + result[i + j + 1] + carry;
            carry = sum / 10;
            result[i + j + 1] = sum % 10;
        }
        result[i] += carry;
    }
    
    string s = "";
    int i = 0;
    while (i < result.size() && result[i] == 0) i++;
    
    while (i < result.size()) {
        s += to_string(result[i++]);
    }
    
    return s ;
}

void solve() {
    string s, c;
    cin >> s >> c;
    
    int lenS = s.size();
    
    for (int i = 0; i < lenS - 1; i++) {
        string a = s.substr(0, i + 1);
        string b = s.substr(i + 1);
        
        if (b.size() > 1 && b[0] == '0') continue;
        
        string product = multiply(b, c);
        
        if (a == product) {
            cout << a << " " << b << endl;
            return;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}