#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;


string multiply(const string& num1, const string& num2) {
    if (num1 == "0" || num2 == "0") {
        return "0";
    }

    int n1 = num1.size();
    int n2 = num2.size();
    vector<int> result(n1 + n2, 0); 

    for (int i = n1 - 1; i >= 0; i--) {
        int carry = 0;
        int digit1 = num1[i] - '0';
        for (int j = n2 - 1; j >= 0; j--) {
            int digit2 = num2[j] - '0';
            int sum = digit1 * digit2 + result[i + j + 1] + carry;
            carry = sum / 10;
            result[i + j + 1] = sum % 10;
        }
        result[i] += carry;
    }

    string res = "";
    int i = 0;
    
    while (i < result.size() - 1 && result[i] == 0) {
        i++;
    }

  
    while (i < result.size()) {
        res += (char)(result[i++] + '0'); // int'i char'a dönüştür.
    }
    
    return res;
}

void solve() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    string s, c_str;
    if (!(cin >> s >> c_str)) {
        return;
    }

    int n = s.length();
    int c_len = c_str.length();

    for (int i = 1; i < n; ++i) {
       
        string a_str = s.substr(0, i);
        string b_str = s.substr(i);
        
        int a_len = a_str.length();
        int b_len = b_str.length();

       
        if (a_len < c_len + b_len - 1 || a_len > c_len + b_len) {
             continue;
        }
        
       
        if ((a_len > 1 && a_str[0] == '0') || (b_len > 1 && b_str[0] == '0')) {
            continue;
        }

     
        string result_multiplied = multiply(c_str, b_str);

  
        if (a_str == result_multiplied) {
           
            cout << a_str << " " << b_str << "\n";
            return;
        }
    }
}

int main() {
    solve();
    return 0;
}