#include <iostream>
#include <vector>
#include <string>
#include <sstream>
#include <set>
#include <tuple>
#include <algorithm>

using namespace std;

bool is_similar(const pair<string, string>& p1, const pair<string, string>& p2) {
    return p1.first == p2.first || p1.second == p2.second;
}

void solve() {
    int t;
    if (!(cin >> t)) return;
    
    while (t--) {
        int n;
        if (!(cin >> n)) return;
        
        vector<pair<string, string>> problems(n);
        set<pair<string, string>> all_problems;
        
        for (int i = 0; i < n; ++i) {
            string w1, w2;
            cin >> w1 >> w2;
            problems[i] = {w1, w2};
            all_problems.insert(problems[i]);
        }
        
        if (n <= 1) {
            cout << "Yes\n";
            continue;
        }

        bool is_correct = true;
        set<pair<string, string>> used_problems;
        used_problems.insert(problems[0]);

        for (int i = 1; i < n; ++i) {
            pair<string, string> prev_problem = problems[i - 1];
            pair<string, string> current_problem = problems[i];
            
            bool similar_available = false;
            
            for (const auto& next_problem : all_problems) {
                if (used_problems.find(next_problem) == used_problems.end()) {
                    if (is_similar(prev_problem, next_problem)) {
                        similar_available = true;
                        break;
                    }
                }
            }
            
            if (similar_available) {
                if (!is_similar(prev_problem, current_problem)) {
                    is_correct = false;
                    break;
                }
            }
            
            used_problems.insert(current_problem);
        }

        if (is_correct) {
            cout << "Yes\n";
        } else {
            cout << "No\n";
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}