#include <iostream>
#include <vector>
#include <string>
#include <sstream>
#include <unordered_map>

using namespace std;

struct Problem {
    string word1;
    string word2;
};

void solve() {
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    if (!(cin >> t)) return; 
    while (t--) {
        int n;
        if (!(cin >> n)) break;

        vector<Problem> problems(n);
        for (int i = 0; i < n; ++i) {
            cin >> problems[i].word1 >> problems[i].word2;
        }

        if (n <= 1) {
            cout << "Yes\n";
            continue;
        }

        bool is_correct = true;

        
        unordered_map<string, int> first_word_counts;
        unordered_map<string, int> second_word_counts;

       
        for (int i = 1; i < n; ++i) {
            first_word_counts[problems[i].word1]++;
            second_word_counts[problems[i].word2]++;
        }

        for (int i = 1; i < n; ++i) {
            const string& prev_w1 = problems[i-1].word1; 
            const string& prev_w2 = problems[i-1].word2; 
            const string& curr_w1 = problems[i].word1;   
            const string& curr_w2 = problems[i].word2;   

            bool similar_available = (first_word_counts.count(prev_w1) && first_word_counts[prev_w1] > 0) || 
                                     (second_word_counts.count(prev_w2) && second_word_counts[prev_w2] > 0);

            if (similar_available) {
                bool is_similar = (curr_w1 == prev_w1) || (curr_w2 == prev_w2);
                
                if (!is_similar) {
                    is_correct = false;
                    break; 
                }
            }
            first_word_counts[curr_w1]--;
            if (first_word_counts[curr_w1] == 0) {
                first_word_counts.erase(curr_w1);
            }
            
            second_word_counts[curr_w2]--;
            if (second_word_counts[curr_w2] == 0) {
                second_word_counts.erase(curr_w2);
            }
        }

        if (is_correct) {
            cout << "Yes\n";
        } else {
            cout << "No\n";
        }
    }
}

int main() {
    solve();
    return 0;
}