import sys
def solve_compact_encoding():
    try:
        n_line = sys.stdin.readline()
        if not n_line:
            return
        n = int(n_line.strip())
    except EOFError:
        return
    except ValueError:
        return
    if n == 0:
        print(0)
        return
    data_chunks = []
    temp_n = n
    while temp_n > 0:
        data_bits = temp_n & 0x7F
        data_chunks.append(data_bits)
        temp_n >>= 7
    data_chunks.reverse()
    k = len(data_chunks)
    encoded_bytes = []
    for i in range(k):
        chunk = data_chunks[i]
        if i < k - 1:
            encoded_bytes.append(chunk + 128)
        else:
            encoded_bytes.append(chunk)
    print(*(encoded_bytes))
if __name__ == "__main__":
    solve_compact_encoding()