import collections
import sys
def solve_games_of_chess():
    try:
        input_data = sys.stdin.read().split()
    except:
        return
    if not input_data:
        return
    t = int(input_data[0])
    results = []
    data_index = 1
    for _ in range(t):
        if data_index >= len(input_data):
            break
        n = int(input_data[data_index])
        m = int(input_data[data_index + 1])
        data_index += 2
        adj = collections.defaultdict(list)
        for __ in range(m):
            u = int(input_data[data_index])
            v = int(input_data[data_index + 1])
            adj[u].append(v)
            adj[v].append(u)
            data_index += 2
        club = [0] * (n + 1)
        is_bipartite = True
        start_node = 1
        if club[start_node] == 0:
            q = collections.deque([start_node])
            club[start_node] = 1 
            while q:
                u = q.popleft()
                for v in adj[u]:
                    if club[v] == 0:
                        club[v] = 3 - club[u]
                        q.append(v)
                    elif club[v] == club[u]:
                        is_bipartite = False
        if is_bipartite:
            results.append("-1")
        else:
            output_clubs = [str(club[i]) for i in range(1, n + 1)]
            results.append(" ".join(output_clubs))
    sys.stdout.write('\n'.join(results) + '\n')
if __name__ == "__main__":
    solve_games_of_chess()