#include "bits/stdc++.h"

using namespace std;

#define ll long long
const ll D = 998244353ll;
const int N = 1e7 + 10;

ll get_lcm(vector<int>& pr, vector<ll>& v) {
    vector<int> pw(N);
    ll ans = 1;

    for (ll y : v) {
        int x = -1;
        int p = 0;
        while (y > 1) {
            int d = pr[y];
            y /= d;
            if (d == x) ++p;
            else {
                if (x != -1) pw[x] = max(pw[x], p);
                p = 1;
                x = d;
            }
        }
        if (x != -1) pw[x] = max(pw[x], p);
    }

    for (ll i = 2; i < N; ++i) {
        for (int j = 0; j < pw[i]; ++j) {
            ans = ans * i % D;
        }
    }

    return ans;
}

ll gcd(ll a, ll b) {
    if (a == 0) return b;
    return gcd(b % a, a);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

ll sol_pref(vector<ll>& v) {
    ll ans = 0;
    vector<ll> suf(v.size());
    suf.back() = gcd(v[0], v.back());
    for (int i = int(v.size()) - 2; i >= 0; --i) {
        suf[i] = gcd(lcm(v[i], suf[i + 1]), v[0]);
    }

    ll g = v[0];
    for (int i = 1; i < v.size(); ++i) {
        ans += gcd(g, suf[i]);
        g = gcd(g, v[i]);
    }
    ans %= D;

    return ans;
}

ll sol(vector<ll>& v) {
    vector<ll> pg(v.size());
    vector<ll> sg(v.size());
    pg[0] = v[0];
    sg.back() = v.back();

    for (int i = 1; i < v.size(); ++i) {
        pg[i] = gcd(pg[i - 1], v[i]);
        sg[v.size() - i - 1] = gcd(sg[v.size() - i], v[v.size() - i - 1]);
    }

    vector<pair<int, int>> segp, segs;
    segp.push_back({0, 0});
    for (int i = 1; i < v.size(); ++i) {
        if (pg[i] == pg[i - 1]) segp.back().second++;
        else segp.push_back({ i, i });
    }
    segs.push_back({ v.size() - 1, v.size() - 1 });
    for (int i = int(v.size()) - 2; i >= 0; --i) {
        if (sg[i] == sg[i + 1]) segs.back().first--;
        else segs.push_back({ i, i });
    }

    auto get_ans = [&](int l1, int r1, int l2, int r2) -> ll {
        if (r2 < l1) return 0;

        r1 = min(r1, r2);
        l2 = max(l2, l1);

        if (r1 < l2) {
            return gcd(pg[l1], sg[r2]) * (ll)(r1 - l1) % D * (ll)(r2 - l2) % D;
        } else if (l1 <= l2 && r2 <= r1) {
            return gcd(pg[l1], sg[r2]) * ((ll)(l2 - l1) * (ll)(r2 - l2) % D + ((ll)(r2 - l2) * (ll)(r2 - l2 - 1) / 2) % D) % D;
        } else if (l2 <= l1 && r1 <= r2) {
            return gcd(pg[l1], sg[r2]) * ((ll)(r2 - r1) * (ll)(r1 - l1) % D + ((ll)(r1 - l1) * (ll)(r1 - l1 - 1) / 2) % D) % D;
        } else {
            return gcd(pg[l1], sg[r2]) * ((ll)(l2 - l1) * (ll)(r2 - l2) % D + ((ll)(r2 - l2 - 1 + (r2 - l2 - 1) - (r1 - l2) + 1) * (r1 - l2) / 2) % D) % D;
        }
    };

    ll ans = 0;
    for (int i = 0; i < segp.size(); ++i) {
        for (int j = 0; j < segs.size(); ++j) {
            ll x = get_ans(segp[i].first, segp[i].second, segs[j].first, segs[j].second);
            ans = (ans + x) % D;
        }
    }

    for (int ti = 0; ti + 1 < segp.size(); ++ti) {
        ll g = pg[segp[ti].first];
        ll l = gcd(v[segp[ti].second + 1], g);
        for (int j = segp[ti].second + 2; j < v.size(); ++j) {
            ans = (ans + gcd(gcd(g, l), sg[j])) % D;
            l = gcd(g, lcm(l, v[j]));
        }
    }

    vector<bool> ok(v.size(), 0);
    for (int i = 0; i < segp.size(); ++i) {
        ok[segp[i].second] = 1;
    }

    for (int ti = 0; ti + 1 < segs.size(); ++ti) {
        ll g = sg[segs[ti].first];
        ll l = gcd(v[segs[ti].first - 1], g);
        for (int j = segs[ti].first - 2; j >= 0; --j) {
            if (!ok[j]) {
                ans = (ans + gcd(gcd(g, l), pg[j])) % D;
            }
            l = gcd(g, lcm(l, v[j]));
        }

    }

    return ans;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    vector<int> pr(N, 1);
    for (ll i = 2; i < N; ++i) {
        if (pr[i] == 1) {
            for (ll j = i; j < N; j += i)
                pr[j] = i;
        }
    }

    int n; cin >> n;
    vector<ll> v(n);
    for (auto &t : v) cin >> t;

    ll ans = get_lcm(pr, v);
    ans = (ans + sol_pref(v)) % D;
    reverse(v.begin(), v.end());
    ans = (ans + sol_pref(v)) % D;
    reverse(v.begin(), v.end());

    ans = (ans + sol(v)) % D;
    cout << ans;
}
