#include "bits/stdc++.h"

using namespace std;

#define ll long long
const ll D = 998244353ll;
const int N = 1e7 + 10;

ll get_lcm(vector<int>& pr, vector<ll>& v) {
    vector<int> pw(N);
    ll ans = 1;

    for (int y : v) {
        int x = -1;
        int p = 0;
        while (y > 1) {
            int d = pr[y];
            y /= d;
            if (d == x) ++p;
            else {
                if (x != -1) pw[x] = max(pw[x], p);
                p = 1;
                x = d;
            }
        }
        if (x != -1) pw[x] = max(pw[x], p);
    }

    for (ll i = 2; i < N; ++i) {
        for (int j = 0; j < pw[i]; ++j) {
            ans = ans * i % D;
        }
    }

    return ans;
}

ll gcd(ll a, ll b) {
    if (a == 0) return b;
    return gcd(b % a, a);
}

ll lcm(ll a, ll b) {
    return a / gcd(a, b) * b;
}

ll sol_pref(vector<ll>& v) {
    ll ans = 0;
    vector<ll> suf(v.size());
    suf.back() = gcd(v[0], v.back());
    for (int i = int(v.size()) - 2; i >= 0; --i) {
        suf[i] = gcd(lcm(v[i], suf[i + 1]), v[0]);
    }

    ll g = v[0];
    for (int i = 1; i < v.size(); ++i) {
        ans += gcd(g, suf[i]);
        g = gcd(g, v[i]);
    }
    ans %= D;

    return ans;
}

ll sol(vector<ll>& v) {
    vector<ll> pg(v.size());
    vector<ll> sg(v.size());
    pg[0] = v[0];
    sg.back() = v.back();

    for (int i = 1; i < v.size(); ++i) {
        pg[i] = gcd(pg[i - 1], v[i]);
        sg[v.size() - i - 1] = gcd(sg[v.size() - i], v[v.size() - i - 1]);
    }

    ll ans = 0;
    for (int i = 1; i < v.size(); ++i) {
        ll l = gcd(pg[i - 1], v[i]);
        for (int j = i; j + 1 < v.size(); ++j) {
            ans = (ans + gcd(pg[i - 1], gcd(sg[j + 1], l))) % D;
            l = gcd(lcm(l, v[j + 1]), v[0]);
        }
    }
    return ans;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    vector<int> pr(N, 1);
    for (ll i = 2; i < N; ++i) {
        if (pr[i] == 1) {
            for (ll j = i; j < N; j += i)
                pr[j] = i;
        }
    }

    int n; cin >> n;
    vector<ll> v(n);
    for (auto &t : v) cin >> t;

    ll ans = get_lcm(pr, v);
    ans = (ans + sol_pref(v)) % D;
    reverse(v.begin(), v.end());
    ans = (ans + sol_pref(v)) % D;
    reverse(v.begin(), v.end());

    ans = (ans + sol(v)) % D;
    cout << ans;
}