#include <iostream>
#include <set>
#include <numeric>
#include <unordered_map>

using namespace std;

using ll = long long;

unordered_map<ll, ll> grandi;

ll g(ll n) {
    auto it = grandi.find(n);
    if (it != grandi.end()) {
        return it->second;
    }

    set<ll> st;
    for (ll i = 1; i < n; i++) {
        if (gcd(i, n - i) != 1) {
            st.insert(g(i) ^ g(n - i));
        }
    }

    for (ll i = 0;; i++) if (st.find(i) == st.end()) return grandi[n] = i;
}

void solve() {
    int n;
    cin >> n;
    ll s = 0;
    for (int i = 0; i < n; i++) {
        ll x;
        cin >> x;
        s ^= g(x);
    }
    cout << (s ? "Yes" : "No");
}

int main() {
    int tests;
    cin >> tests;

    while (tests--) {
        solve();
        cout << '\n';
    }
}