#include <bits/stdc++.h>

#include "testlib.h"

using namespace std;

struct Event {
    long long t;
    string name;
    long long len;
};

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);

    long long N = opt<long long>(1);
    long long M = opt<long long>(2);
    long long maxLen = opt<long long>(3);
    long long maxT = opt<long long>(4);
    int pZero = opt<int>(5, 20);
    int pBurst = opt<int>(6, 50);
    int minNL = opt<int>(7, 3);
    int maxNL = opt<int>(8, 10);

    vector<pair<string, long long>> base;
    for (long long i = 0; i < N; ++i) {
        int L = rnd.next(minNL, maxNL);
        string name = rnd.next("[A-Za-z]{" + toString(L) + "}");
        long long len = rnd.next(1LL, maxLen);
        base.emplace_back(name, len);
    }

    vector<Event> events;
    vector<long long> times;

    for (long long j = 0; j < M; ++j) {
        long long t;
        int r = rnd.next(0, 99);
        if (r < pZero) {
            t = 0;
        } else if (!times.empty() && rnd.next(0, 99) < pBurst) {
            t = times[(size_t)rnd.next(0, (int)times.size() - 1)];
        } else {
            if (maxT == 0) {
                t = 0;
            } else {
                t = rnd.next(0LL, maxT);
            }
        }
        times.push_back(t);

        int L = rnd.next(minNL, maxNL);
        string name = rnd.next("[A-Za-z]{" + toString(L) + "}");
        long long len = rnd.next(1LL, maxLen);
        events.push_back({t, name, len});
    }

    stable_sort(events.begin(), events.end(),
                [](const Event& a, const Event& b) { return a.t < b.t; });

    println(N);
    for (auto& p : base) {
        cout << p.first << ' ' << p.second << '\n';
    }
    println(M);
    for (auto& e : events) {
        cout << e.t << ' ' << e.name << ' ' << e.len << '\n';
    }
    return 0;
}
