import sys
from collections import deque

def main():
    rd = sys.stdin.buffer.readline
    n = int(rd())

    playlist = deque()
    for _ in range(n):
        name, ln = rd().split()
        playlist.append((name.decode(), int(ln)))

    m = int(rd())
    # Храним события в раздельных массивах (дешевле объектов/кортежей)
    et = [0]*m
    en = [None]*m
    el = [0]*m
    for i in range(m):
        t_s, name_s, len_s = rd().split()
        et[i] = int(t_s)
        en[i] = name_s.decode()
        el[i] = int(len_s)
    # Гарантируется неубывание et, так что сортировка не нужна.

    i = 0
    while i < m and et[i] == 0:
        # события в момент 0 попадают в голову до старта
        playlist.appendleft((en[i], el[i]))
        i += 1

    cur_time = 0
    playing = True
    cur_name, cur_len = playlist[0]
    out = []
    out.append(f"{cur_name} 0\n")
    playlist.popleft()

    while True:
        if playing:
            # на интервале (cur_time, cur_time + cur_len] добавляем ВСЕ события
            end_time = cur_time + cur_len
            while i < m and et[i] <= end_time:
                playlist.appendleft((en[i], el[i]))
                i += 1
            playing = False
            cur_time = end_time
        else:
            if i < m:
                cur_time = et[i]
                # когда ждём, должны забрать ВСЕ события с минимальным временем cur_time
                while i < m and et[i] == cur_time:
                    playlist.appendleft((en[i], el[i]))
                    i += 1
            else:
                break

        if playlist:
            cur_name, cur_len = playlist[0]
            playlist.popleft()
            playing = True
            out.append(f"{cur_name} {cur_time}\n")
        else:
            playing = False

    sys.stdout.write("".join(out))

if __name__ == "__main__":
    main()
