from collections import deque

class Track:
    def __init__(self, name, length):
        self.name = name
        self.len = length

class Event:
    def __init__(self, t, name, length):
        self.t = t
        self.name = name
        self.len = length

n = int(input())

playlist = deque()
for _ in range(n):
    tmp = input().split()
    playlist.append(Track(tmp[0], int(tmp[1])))

m = int(input())
events = []
for _ in range(m):
    tmp = input().split()
    events.append(Event(int(tmp[0]), tmp[1], int(tmp[2])))
    
i = 0
while i < len(events) and events[i].t == 0:
    playlist.appendleft(Track(events[i].name, events[i].len))
    i += 1

cur_time = 0
playing = True
cur_name = playlist[0].name
cur_len = playlist[0].len
ans = [Track(cur_name, 0)]

playlist.popleft()

while True:
    if playing:
        while i < len(events) and events[i].t <= cur_time + cur_len:
            playlist.appendleft(Track(events[i].name, events[i].len))
            i += 1
        playing = False
        cur_time += cur_len
    else:
        if i < len(events):
            cur_time = events[i].t
            while i < len(events) and events[i].t == cur_time:
                playlist.appendleft(Track(events[i].name, events[i].len))
                i += 1
        else:
            break
    if playlist:
        cur_name = playlist[0].name
        cur_len = playlist[0].len
        playlist.popleft()
        playing = True
        ans.append(Track(cur_name, cur_time))
    else:
        playing = False

for p in ans:
    print(p.name, p.len)

