#include <bits/stdc++.h>
using namespace std;

struct Track {
    string name;
    long long len;
};

struct Event {
    long long t;
    string name;
    long long len;
};

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int n;
    cin >> n;

    vector<Track> playlist(n);
    for (int i = 0; i < n; ++i) {
        cin >> playlist[i].name >> playlist[i].len;
    }

    int m;
    cin >> m;
    vector<Event> events(m);
    for (int i = 0; i < m; ++i) {
        cin >> events[i].t >> events[i].name >> events[i].len;
    }

    long long cur_time = 0;
    bool playing = false;
    string cur_name;
    long long cur_len;
    vector<Track> ans;

    size_t i = 0;

    while (i < events.size() && events[i].t == 0) {
        playlist.insert(playlist.begin(), Track{events[i].name, events[i].len});
        ++i;
    }

    cur_name = playlist.front().name;
    cur_len = playlist.front().len;
    playlist.erase(playlist.begin());
    playing = true;
    ans.emplace_back(Track{cur_name, 0});

    while (true) {
        if (playing) {
            cur_time += cur_len;
            while (i < events.size() && events[i].t <= cur_time) {
                playlist.insert(playlist.begin(),
                                Track{events[i].name, events[i].len});
                ++i;
            }
            playing = false;
        } else {
            if (i < events.size()) {
                cur_time = events[i].t;
                while (i < events.size() && events[i].t == cur_time) {
                    playlist.insert(playlist.begin(),
                                    Track{events[i].name, events[i].len});
                    ++i;
                }
            } else {
                break;
            }
        }

        if (!playlist.empty()) {
            cur_name = playlist.front().name;
            cur_len = playlist.front().len;
            playlist.erase(playlist.begin());
            playing = true;
            ans.emplace_back(Track{cur_name, cur_time});
        } else {
            playing = false;
        }
    }

    for (auto& p : ans) {
        cout << p.name << ' ' << p.len << '\n';
    }
    return 0;
}
