#include <bits/stdc++.h>

using namespace std;

struct Track {
    string name;
    long long len;
};

struct Event {
    long long t;
    string name;
    long long len;
};

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int n;
    cin >> n;

    deque<Track> playlist(n);
    for (int i = 0; i < n; ++i) {
        cin >> playlist[i].name >> playlist[i].len;
    }

    int m;
    cin >> m;
    vector<Event> events(m);
    for (int i = 0; i < m; ++i) {
        cin >> events[i].t >> events[i].name >> events[i].len;
    }

    size_t i = 0;
    while (i < events.size() && events[i].t == 0) {
        playlist.push_front({events[i].name, events[i].len});
        ++i;
    }

    long long cur_time = 0;
    bool playing = true;
    string cur_name = playlist[0].name;
    long long cur_len = playlist[0].len;
    vector<Track> ans;

    ans.emplace_back(playlist[0].name, 0);
    playlist.pop_front();

    while (true) {
        if (playing) {
            if (i < events.size() && events[i].t <= cur_time + cur_len) {
                playlist.push_front({events[i].name, events[i].len});
                ++i;
            }
            playing = false;
            cur_time += cur_len;
        } else {
            if (i < events.size()) {
                cur_time = events[i].t;
                while (i < events.size() && events[i].t == cur_time) {
                    playlist.push_front({events[i].name, events[i].len});
                    ++i;
                }
            } else {
                break;
            }
        }
        if (!playlist.empty()) {
            cur_name = playlist.front().name;
            cur_len = playlist.front().len;
            playlist.pop_front();
            playing = true;
            ans.emplace_back(cur_name, cur_time);
        } else {
            playing = false;
        }
    }

    for (auto& p : ans) {
        cout << p.name << ' ' << p.len << '\n';
    }

    return 0;
}
