#include "testlib.h"
#include "constants.h"

using namespace std;

using ll = long long;

int get(int from, int to) {
    return rnd.next(from, to);
}

template<typename T>
T get_opt(const string &key, const T &d) {
    return has_opt(key) ? opt<T>(key) : d;
}

int main(int argc, char *argv[]) {
    registerGen(argc, argv, 1);

    int p1 = get_opt("p1", 2);
    int p2 = get_opt("p2", 3);
    int p3 = get_opt("p3", 5);
    int p4 = get_opt("p4", -1);
    int p5 = get_opt("p5", -1);
    vector<int> arr = {p1, p2, p3};
    int mult = p1 * p2 * p3;
    if (p4 != -1) arr.push_back(p4), mult *= p4;
    if (p5 != -1) arr.push_back(p5), mult *= p5;
    cout << "1\n";
    int n = constants::MAX_N;
    int X = 1;

    cout << n << ' ' << X << '\n';
    for (int i = 0; i < n; i++) {
        int randp = arr[get(0, arr.size() - 1)];
        int cur = mult / randp;
        int k = get(1, constants::MAX_X / cur);
        cout << k * cur;
        if (i != n - 1) cout << ' ';
    }
    cout << '\n';
    for (int i = 0; i < n; i++) {
        cout << get(50, 100);
        if (i != n - 1) cout << ' ';
    }
    cout << '\n';
}
