#include <iostream>
#include <vector>
#include <numeric>

using namespace std;

using ll = long long;

const ll INF = 4e18;

const int maxx = 3e3 + 100;

void solve() {
    int n, X;
    cin >> n >> X;
    X = abs(X);

    vector<int> x(n), c(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> c[i];

    vector<vector<ll>> dp(n + 1, vector<ll>(maxx, INF));
    dp[0][0] = 0;
    for (int i = 0; i < n; i++) {
        dp[i + 1] = dp[i];
        for (int j = 0; j < maxx; j++) {
            if (dp[i][j] == INF) continue;
            int g = std::gcd(j, x[i]);
            dp[i + 1][g] = min(dp[i + 1][g], dp[i][j] + c[i]);
        }
    }
    ll ans = INF;
    for (int i = 1; i < maxx; i++) if (X % i == 0) ans = min(ans, dp.back()[i]);
    cout << (ans == INF ? -1 : ans) << '\n';
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    while (t--) solve();
}
