#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll INF = 4e18;

void solve() {
    int n;
    ll X;
    cin >> n >> X;

    vector<ll> x(n), c(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> c[i];

    unordered_map<ll, ll> best;

    for (int i = 0; i < n; ++i) {
        unordered_map<ll, ll> nxt = best;

        auto it = nxt.find(x[i]);
        if (it == nxt.end() || it->second > c[i])
            nxt[x[i]] = c[i];

        for (auto [g, cost]: best) {
            ll g2 = std::gcd(g, x[i]);
            ll total = cost + c[i];
            auto jt = nxt.find(g2);
            if (jt == nxt.end() || jt->second > total)
                nxt[g2] = total;
        }
        best.swap(nxt);
    }

    ll ans = INF;
    for (auto [g, cost]: best)
        if (X % g == 0)
            ans = min(ans, cost);

    cout << (ans == INF ? -1 : ans) << '\n';
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;
    while (t--) solve();
}
